/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.FutureTask;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.Pair;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.rules.AbstractRule;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.dataproviders.HaltsProvider;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.openjdk.jmc.flightrecorder.rules.util.SlidingWindowToolkit;

public class GcPauseRatioRule
extends AbstractRule {
    private static final TypedPreference<IQuantity> INFO_LIMIT = new TypedPreference("gc.pauseratio.info.limit", Messages.getString("GcPauseRatioRule_INFO_LIMIT"), Messages.getString("GcPauseRatioRule_INFO_LIMIT_DESC"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(5L));
    private static final TypedPreference<IQuantity> WARNING_LIMIT = new TypedPreference("gc.pauseratio.warning.limit", Messages.getString("GcPauseRatioRule_WARNING_LIMIT"), Messages.getString("GcPauseRatioRule_WARNING_LIMIT_DESC"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(10L));
    private static final TypedPreference<IQuantity> WINDOW_SIZE = new TypedPreference("gc.pauseratio.window.size", Messages.getString("GcPauseRatioRule_WINDOW_SIZE"), Messages.getString("GcPauseRatioRule_WINDOW_SIZE_DESC"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.SECOND.quantity(60L));
    private static final Collection<TypedPreference<?>> CONFIGURATION_ATTRIBUTES = Arrays.asList(INFO_LIMIT, WARNING_LIMIT, WINDOW_SIZE);
    public static final TypedResult<IQuantity> GC_PAUSE_RATIO = new TypedResult("gcPauseRatio", "GC Pause Ratio", "The percent of time spent in GC.", (ContentType)UnitLookup.PERCENTAGE, IQuantity.class);
    public static final TypedResult<IRange<IQuantity>> WINDOW = new TypedResult("gcPauseWindow", "GC Pause Window", "The window reported for the gc pause ratio.", UnitLookup.TIMERANGE);
    public static final TypedResult<IQuantity> GC_PAUSE_RATIO_WINDOW = new TypedResult("gcPauseRatioWindow", "GC Pause Ratio (Window)", "The gc pause ratio in the reported window.", (ContentType)UnitLookup.PERCENTAGE, IQuantity.class);
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.GCPhasePause", RulesToolkit.EventAvailability.ENABLED).build();
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, GC_PAUSE_RATIO, GC_PAUSE_RATIO_WINDOW, WINDOW);

    public GcPauseRatioRule() {
        super("GcPauseRatio", Messages.getString("GcPauseRatioRule_RULE_NAME"), "garbage_collection", CONFIGURATION_ATTRIBUTES, RESULT_ATTRIBUTES, REQUIRED_EVENTS);
    }

    protected IResult getResult(IItemCollection items, IPreferenceValueProvider vp, IResultValueProvider rp) {
        IQuantity infoLimit = (IQuantity)vp.getPreferenceValue(INFO_LIMIT);
        IQuantity warningLimit = (IQuantity)vp.getPreferenceValue(WARNING_LIMIT);
        IQuantity windowSize = (IQuantity)vp.getPreferenceValue(WINDOW_SIZE);
        IQuantity haltsTotalRatio = HaltsProvider.calculateGcPauseRatio(items);
        Pair haltsWindowRatio = SlidingWindowToolkit.slidingWindowUnorderedMinMaxValue((IItemCollection)items, (IQuantity)windowSize, (FutureTask)this.evaluationTask, HaltsProvider.gcHaltsRatioFunction(), (boolean)true, (boolean)true);
        double score = RulesToolkit.mapExp100((double)((IQuantity)haltsWindowRatio.left).doubleValue(), (double)infoLimit.doubleValue(), (double)warningLimit.doubleValue());
        String shortDescription = score >= 25.0 ? Messages.getString("GcPauseRatioRule_RULE_TEXT") : Messages.getString("GcPauseRatioRule_RULE_TEXT_OK");
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.get((double)score)).setSummary(shortDescription).setExplanation(Messages.getString("GcPauseRatioRule_RULE_TEXT_LONG")).setSolution(Messages.getString("GcPauseRatioRule_RULE_TEXT_RECOMMENDATION")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).addResult(GC_PAUSE_RATIO, (Object)haltsTotalRatio).addResult(WINDOW, (Object)((IRange)haltsWindowRatio.right)).addResult(GC_PAUSE_RATIO_WINDOW, (Object)((IQuantity)haltsWindowRatio.left)).build();
    }
}

