/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.GroupingAggregator;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class HeapContentRule
implements IRule {
    private static final IAggregator<IQuantity, ?> HEAP_CONTENT_SCORE_AGGREGATOR = GroupingAggregator.build((String)Messages.getString("HeapContentRule_AGGR_CLASS_SCORE"), null, (IAccessorFactory)JdkAttributes.OBJECT_CLASS, (IAggregator)JdkAggregators.OBJECT_COUNT_MAX_SIZE, (GroupingAggregator.IQuantityListFinisher)new GroupingAggregator.IQuantityListFinisher<IQuantity>(){

        public IType<IQuantity> getValueType() {
            return UnitLookup.NUMBER;
        }

        public IQuantity getValue(List<IQuantity> t, IQuantity u) {
            double classScore = 0.0;
            for (int i = 0; i < t.size(); ++i) {
                classScore += t.get(i).doubleValue() / u.doubleValue() / (double)(t.size() - i);
            }
            return UnitLookup.NUMBER_UNITY.quantity(classScore);
        }
    });
    private static final String RESULT_ID = "HeapContent";
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.ObjectCount", RulesToolkit.EventAvailability.ENABLED).build();
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE);

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        double score;
        IQuantity aggregate = (IQuantity)items.getAggregate(HEAP_CONTENT_SCORE_AGGREGATOR);
        double d = score = aggregate == null ? 0.0 : RulesToolkit.mapExp100((double)aggregate.doubleValue(), (double)0.75);
        if (score >= 25.0) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.get((double)score)).setSummary(Messages.getString("HeapContentRuleFactory_TEXT_INFO")).setExplanation(Messages.getString("HeapContentRuleFactory_TEXT_INFO_LONG")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.get((double)score)).setSummary(Messages.getString("HeapContentRuleFactory_TEXT_OK")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).build();
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return HeapContentRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("HeapContentRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "heap";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

