/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.ui.swt;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openjdk.jmc.joverflow.ui.swt.TreemapItem;

class SquarifiedTreemap {
    private LinkedList<TreemapItem> elements = new LinkedList();
    private double totalRealWeight;
    private Rectangle2D.Double container;
    private DIRECTION drawingDir;
    private Rectangle2D.Double availableRegion;
    private double initialArea;
    private Map<TreemapItem, Rectangle2D.Double> squarifiedMap;
    private double lastX = 0.0;
    private double lastY = 0.0;

    public SquarifiedTreemap(Rectangle2D.Double region, List<TreemapItem> elements) {
        this.elements.addAll((Collection<TreemapItem>)Objects.requireNonNull(elements));
        this.totalRealWeight = this.getRealSum(elements);
        this.container = Objects.requireNonNull(region);
        this.squarifiedMap = new HashMap<TreemapItem, Rectangle2D.Double>();
    }

    public Map<TreemapItem, Rectangle2D.Double> squarify() {
        if (this.elements.isEmpty()) {
            return Collections.emptyMap();
        }
        this.initialArea = this.container.getWidth() * this.container.getHeight();
        this.availableRegion = new Rectangle2D.Double(this.container.getX(), this.container.getY(), this.container.getWidth(), this.container.getHeight());
        this.lastX = 0.0;
        this.lastY = 0.0;
        this.updateDirection();
        ArrayList<TreemapItem> row = new ArrayList<TreemapItem>();
        this.squarifyHelper(this.elements, row, 0.0, this.getPrincipalSide());
        return this.squarifiedMap;
    }

    private void squarifyHelper(LinkedList<TreemapItem> nodes, List<TreemapItem> row, double rowArea, double side) {
        if (nodes.isEmpty() && row.isEmpty()) {
            return;
        }
        if (nodes.isEmpty()) {
            this.finalizeRow(row, rowArea);
            return;
        }
        if (row.isEmpty()) {
            row.add(nodes.getFirst());
            double realWeight = nodes.getFirst().getWeight();
            nodes.removeFirst();
            double nodeArea = realWeight / this.totalRealWeight * this.initialArea;
            this.squarifyHelper(nodes, row, nodeArea, side);
            return;
        }
        ArrayList<TreemapItem> expandedRow = new ArrayList<TreemapItem>(row);
        expandedRow.add(nodes.getFirst());
        double realWeight = nodes.getFirst().getWeight();
        double nodeArea = realWeight / this.totalRealWeight * this.initialArea;
        double expandedRowArea = rowArea + nodeArea;
        double actualAspectRatio = this.maxAspectRatio(row, rowArea, side);
        double expandedAspectRatio = this.maxAspectRatio(expandedRow, expandedRowArea, side);
        if (!this.willImprove(actualAspectRatio, expandedAspectRatio)) {
            this.finalizeRow(row, rowArea);
            this.squarifyHelper(nodes, new ArrayList<TreemapItem>(), 0.0, this.getPrincipalSide());
        } else {
            nodes.removeFirst();
            this.squarifyHelper(nodes, expandedRow, expandedRowArea, side);
        }
    }

    public Map<TreemapItem, Rectangle2D.Double> getSquarifiedMap() {
        return this.squarifiedMap;
    }

    private void updateDirection() {
        this.drawingDir = this.availableRegion.getWidth() > this.availableRegion.getHeight() ? DIRECTION.TOP_BOTTOM : DIRECTION.LEFT_RIGHT;
    }

    private void invertDirection() {
        this.drawingDir = this.drawingDir == DIRECTION.LEFT_RIGHT ? DIRECTION.TOP_BOTTOM : DIRECTION.LEFT_RIGHT;
    }

    private void finalizeRow(List<TreemapItem> row, double rowArea) {
        double alternativeAR;
        if (row == null || row.isEmpty()) {
            return;
        }
        double actualAR = this.maxAspectRatio(row, rowArea, this.getPrincipalSide());
        if (this.willImprove(actualAR, alternativeAR = this.maxAspectRatio(row, rowArea, this.getSecondarySide()))) {
            this.invertDirection();
        }
        Rectangle2D.Double reference = null;
        for (TreemapItem node : row) {
            Rectangle2D.Double r = this.createRectangle(rowArea, node.getWeight() / this.getRealSum(row));
            this.updateXY(r);
            this.squarifiedMap.put(node, r);
            if (reference != null) continue;
            reference = r;
        }
        this.reduceAvailableArea(reference);
    }

    private Rectangle2D.Double createRectangle(Double rowArea, Double fraction) {
        double h;
        double w;
        double side = this.getPrincipalSide();
        if (this.validate(fraction) == 0.0 || this.validate(rowArea) == 0.0 || this.validate(side) == 0.0) {
            return new Rectangle2D.Double(this.lastX, this.lastY, 0.0, 0.0);
        }
        if (this.drawingDir == DIRECTION.TOP_BOTTOM) {
            w = rowArea / side;
            h = fraction * side;
        } else {
            w = fraction * side;
            h = rowArea / side;
        }
        return new Rectangle2D.Double(this.lastX, this.lastY, w, h);
    }

    double validate(double d) {
        if (Double.isNaN(d)) {
            return 0.0;
        }
        return d;
    }

    private double getPrincipalSide() {
        return this.drawingDir == DIRECTION.LEFT_RIGHT ? this.availableRegion.getWidth() : this.availableRegion.getHeight();
    }

    private double getSecondarySide() {
        return this.drawingDir == DIRECTION.LEFT_RIGHT ? this.availableRegion.getHeight() : this.availableRegion.getWidth();
    }

    private double getRealSum(List<TreemapItem> nodes) {
        double sum = 0.0;
        for (TreemapItem node : nodes) {
            sum += node.getWeight();
        }
        return sum;
    }

    private void updateXY(Rectangle2D.Double r) {
        if (this.drawingDir == DIRECTION.LEFT_RIGHT) {
            this.lastX += r.width;
        } else {
            this.lastY += r.height;
        }
    }

    private void initializeXY(Rectangle2D.Double r) {
        this.lastX = r.x;
        this.lastY = r.y;
    }

    private void reduceAvailableArea(Rectangle2D.Double reference) {
        if (this.drawingDir == DIRECTION.LEFT_RIGHT) {
            this.availableRegion.height -= reference.height;
            this.availableRegion.y = this.lastY + reference.height;
            this.availableRegion.x = reference.x;
        } else {
            this.availableRegion.width -= reference.width;
            this.availableRegion.x = this.lastX + reference.width;
            this.availableRegion.y = reference.y;
        }
        this.updateDirection();
        this.initializeXY(this.availableRegion);
    }

    private double maxAspectRatio(List<TreemapItem> row, double rowArea, double side) {
        if (row == null || row.isEmpty()) {
            return Double.MAX_VALUE;
        }
        double realSum = this.getRealSum(row);
        double maxRatio = 0.0;
        Iterator<TreemapItem> iterator = row.iterator();
        while (iterator.hasNext()) {
            double length = rowArea / side;
            TreemapItem node = iterator.next();
            double fraction = node.getWeight() / realSum;
            double width = fraction * side;
            double currentRatio = Math.max(length / width, width / length);
            if (!(currentRatio > maxRatio)) continue;
            maxRatio = currentRatio;
        }
        return maxRatio;
    }

    private boolean willImprove(double actualAR, double expandedAR) {
        double v2;
        if (actualAR == 0.0) {
            return true;
        }
        if (expandedAR == 0.0) {
            return false;
        }
        double v1 = Math.abs(actualAR - 1.0);
        return v1 > (v2 = Math.abs(expandedAR - 1.0));
    }

    private static enum DIRECTION {
        LEFT_RIGHT,
        TOP_BOTTOM;

    }
}

