/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.ui.swt;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.openjdk.jmc.joverflow.ui.swt.SquarifiedTreemap;
import org.openjdk.jmc.joverflow.ui.swt.Treemap;

public class TreemapItem
extends Item {
    private static final String ELLIPSIS = "...";
    private static final int HORIZONTAL_PADDING = 13;
    private static final int VERTICAL_PADDING = 13;
    private static final int MIN_SIZE = 1;
    private Treemap parent;
    private TreemapItem parentItem;
    private List<TreemapItem> children = new ArrayList<TreemapItem>();
    private Color background = null;
    private Color foreground = null;
    private Font font = null;
    private Rectangle bounds = null;
    private Rectangle textBounds = null;
    private double realWeight = 0.0;
    private double apparentWeight = -1.0;
    private String toolTipText = "";
    private Color darkenBackground = null;

    public TreemapItem(Treemap parent, int style) {
        this(Treemap.checkNull(parent), parent.getRootItem(), style);
    }

    public TreemapItem(TreemapItem parentItem, int style) {
        this(TreemapItem.checkNull((TreemapItem)parentItem).parent, parentItem, style);
    }

    private TreemapItem(Treemap parent, TreemapItem parentItem, int style) {
        super((Widget)parent, style);
        if ((style & 0x10000000) == 0x10000000) {
            throw new UnsupportedOperationException("SWT.VIRTUAL is not support by TreemapItem");
        }
        this.parent = parent;
        this.parentItem = parentItem;
        if (parentItem != null) {
            parentItem.children.add(this);
        }
    }

    static TreemapItem checkNull(TreemapItem item) {
        if (item == null) {
            SWT.error((int)4);
        }
        return item;
    }

    private void sortChildren() {
        this.children.sort(Comparator.comparingDouble(TreemapItem::getWeight).reversed());
    }

    void updateAncestor() {
        TreemapItem ancestor = this.parentItem;
        while (ancestor != null) {
            ancestor.sortChildren();
            ancestor.cacheApparentWeight();
            ancestor = ancestor.parentItem;
        }
    }

    private void clearThis() {
        this.realWeight = 0.0;
        this.apparentWeight = -1.0;
        this.foreground = null;
        this.background = null;
        this.font = null;
        if (this.darkenBackground != null && !this.darkenBackground.isDisposed()) {
            this.darkenBackground.dispose();
        }
        this.darkenBackground = null;
        this.setData(null);
        this.setText("");
        this.setToolTipText("");
        this.updateAncestor();
    }

    private void cacheApparentWeight() {
        double sum = 0.0;
        for (TreemapItem child : this.children) {
            sum += child.getWeight();
        }
        this.apparentWeight = sum += this.realWeight;
    }

    void paintItem(GC gc, Rectangle bounds, boolean all) {
        this.bounds = bounds;
        Color bg = gc.getBackground();
        Color fg = gc.getForeground();
        Font font = gc.getFont();
        gc.setBackground(this.parent.getSelection() == this ? this.getDarkenBackground() : this.getBackground());
        gc.fillRectangle(bounds);
        if (this.getParent().getBordersVisible()) {
            gc.setForeground(this.getDarkenBackground());
            gc.drawRectangle(bounds);
        }
        gc.setFont(this.getFont());
        this.paintTextIfPossible(gc);
        if (all) {
            this.paintChildrenIfPossible(gc);
        } else {
            TreemapItem[] treemapItemArray = this.getItems();
            int n = treemapItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreemapItem child = treemapItemArray[n2];
                child.clearBounds(true);
                ++n2;
            }
        }
        gc.setBackground(bg);
        gc.setForeground(fg);
        gc.setFont(font);
    }

    private void paintTextIfPossible(GC gc) {
        String text = this.getText();
        if (text == null || text.equals("")) {
            return;
        }
        if (!this.tryPaintText(gc, text)) {
            this.tryPaintText(gc, ELLIPSIS);
        }
    }

    private boolean tryPaintText(GC gc, String text) {
        Rectangle textBounds = this.getParent().getBordersVisible() ? new Rectangle(this.bounds.x, this.bounds.y, this.bounds.width - 2, this.bounds.height - 2) : new Rectangle(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        Point textExtent = gc.textExtent(text);
        if (textExtent.x > textBounds.width || textExtent.y > textBounds.height) {
            this.textBounds = null;
            return false;
        }
        textBounds.width = textExtent.x;
        textBounds.height = textExtent.y;
        gc.setFont(this.getFont());
        gc.setForeground(this.getForeground());
        if (this.getParent().getBordersVisible()) {
            gc.drawText(text, this.bounds.x + 1, this.bounds.y + 1);
        } else {
            gc.drawText(text, this.bounds.x, this.bounds.y);
        }
        this.textBounds = textBounds;
        return true;
    }

    private void paintChildrenIfPossible(GC gc) {
        double w = Math.max(0, this.bounds.width - 26);
        double h = Math.max(0, this.bounds.height - 26);
        if (this.textBounds != null && this.textBounds.height > 13) {
            h = h - (double)this.textBounds.height + 13.0;
        }
        Rectangle2D.Double availableRegion = new Rectangle2D.Double(0.0, 0.0, w, h);
        if (availableRegion.width == 0.0 || availableRegion.height == 0.0) {
            return;
        }
        List<TreemapItem> elements = Arrays.asList(this.getItems());
        SquarifiedTreemap algorithm = new SquarifiedTreemap(availableRegion, elements);
        Map<TreemapItem, Rectangle2D.Double> squarifiedMap = algorithm.squarify();
        for (TreemapItem item : elements) {
            Rectangle2D.Double childRect = squarifiedMap.get((Object)item);
            if (childRect.width < 1.0 || childRect.height < 1.0) {
                item.clearBounds(true);
                continue;
            }
            Rectangle2D.Double childBounds = squarifiedMap.get((Object)item);
            int x = (int)childBounds.x + this.bounds.x + 13;
            int y = (int)childBounds.y + this.bounds.y + 13;
            if (this.textBounds != null && this.textBounds.height > 13) {
                y = y + this.textBounds.height - 13;
            }
            int w2 = (int)childBounds.width;
            int h2 = (int)childBounds.height;
            item.paintItem(gc, new Rectangle(x, y, w2, h2), true);
        }
    }

    private void clearBounds(boolean all) {
        this.bounds = null;
        this.textBounds = null;
        if (!all) {
            return;
        }
        TreemapItem[] treemapItemArray = this.getItems();
        int n = treemapItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreemapItem child = treemapItemArray[n2];
            child.clearBounds(true);
            ++n2;
        }
    }

    public void clear(int index, boolean all) {
        this.checkWidget();
        TreemapItem target = this.children.get(index);
        target.clearThis();
        if (all) {
            target.clearAll(true);
        }
    }

    public void clearAll(boolean all) {
        this.checkWidget();
        this.children.forEach(item -> {
            item.clearThis();
            if (all) {
                item.clearAll(true);
            }
        });
    }

    public void dispose() {
        if (this.darkenBackground != null && !this.darkenBackground.isDisposed()) {
            this.darkenBackground.dispose();
        }
        super.dispose();
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.background != null) {
            return this.background;
        }
        if (this.parentItem != null) {
            return this.parentItem.getBackground();
        }
        return this.parent.getBackground();
    }

    private Color getDarkenBackground() {
        if (this.darkenBackground == null || this.darkenBackground.isDisposed()) {
            Color bg = this.getBackground();
            int r = (int)((double)bg.getRed() * 0.8);
            int g = (int)((double)bg.getGreen() * 0.8);
            int b = (int)((double)bg.getBlue() * 0.8);
            this.darkenBackground = new Color((Device)Display.getCurrent(), r, g, b);
        }
        return this.darkenBackground;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        this.background = color;
        if (this.darkenBackground != null && !this.darkenBackground.isDisposed()) {
            this.darkenBackground.dispose();
        }
        this.darkenBackground = null;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return this.bounds;
    }

    public Font getFont() {
        this.checkWidget();
        if (this.font != null) {
            return this.font;
        }
        if (this.parentItem != null) {
            return this.parentItem.getFont();
        }
        return this.parent.getFont();
    }

    public void setFont(Font font) {
        this.checkWidget();
        this.font = font;
    }

    public Color getForeground() {
        this.checkWidget();
        if (this.foreground != null) {
            return this.foreground;
        }
        if (this.parentItem != null) {
            return this.parentItem.getForeground();
        }
        return this.parent.getForeground();
    }

    public void setForeground(Color color) {
        this.checkWidget();
        this.foreground = color;
    }

    public TreemapItem getItem(int index) {
        this.checkWidget();
        return this.children.get(index);
    }

    public TreemapItem getItem(Point point) {
        this.checkWidget();
        if (this.getBounds() == null || !this.getBounds().contains(point)) {
            return null;
        }
        for (TreemapItem child : this.children) {
            if (child.getBounds() == null || !child.getBounds().contains(point)) continue;
            return child.getItem(point);
        }
        return this;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.children.size();
    }

    public TreemapItem[] getItems() {
        this.checkWidget();
        return this.children.toArray(new TreemapItem[0]);
    }

    public Treemap getParent() {
        this.checkWidget();
        return this.parent;
    }

    public TreemapItem getParentItem() {
        this.checkWidget();
        return this.parentItem;
    }

    public Rectangle getTextBounds() {
        this.checkWidget();
        return this.textBounds;
    }

    public double getWeight() {
        this.checkWidget();
        if (this.apparentWeight == -1.0) {
            this.cacheApparentWeight();
        }
        return this.apparentWeight;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public void setToolTipText(String text) {
        this.checkWidget();
        Objects.requireNonNull(text);
        this.toolTipText = text;
    }

    public void setWeight(double weight) {
        this.checkWidget();
        if (weight < 0.0) {
            throw new IllegalArgumentException("weight must be positive");
        }
        this.realWeight = weight;
        this.apparentWeight = -1.0;
        this.updateAncestor();
    }

    public int indexOf(TreemapItem item) {
        this.checkWidget();
        return this.children.indexOf((Object)item);
    }

    public void remove(int index) {
        this.checkWidget();
        TreemapItem item = this.getItem(index);
        this.children.remove((Object)item);
    }

    public void removeAll() {
        this.checkWidget();
        for (TreemapItem child : this.children) {
            child.removeAll();
        }
        this.children.clear();
    }
}

