/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.openjdk.jmc.commands.Command;
import org.openjdk.jmc.commands.ICommandHelper;
import org.openjdk.jmc.commands.Parameter;

class CommandFactory {
    private static final Logger LOGGER = Logger.getLogger("org.openjdk.jmc.commands");
    private static final String DESCRIPTION = "description";
    private static final String IDENTIFIER = "identifier";
    private static final String NAME = "name";
    private static final String CLASS = "class";
    private static final String CATEGORY = "category";
    private static final String EXTENSION_POINT_ID = "org.openjdk.jmc.commands.command";
    private static final String EXTENSION_NAME = "command";
    private static final String COMMAND_HELPER = "commandHelper";

    CommandFactory() {
    }

    static List<Command> createFromExtensionPoints() {
        ArrayList<Command> commands = new ArrayList<Command>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint exPoint = registry.getExtensionPoint(EXTENSION_POINT_ID);
        if (exPoint != null) {
            commands.addAll(CommandFactory.createForExtensionPoint(exPoint));
        }
        return commands;
    }

    private static List<Command> createForExtensionPoint(IExtensionPoint exPoint) {
        IExtension[] ext;
        ArrayList<Command> commands = new ArrayList<Command>();
        IExtension[] iExtensionArray = ext = exPoint.getExtensions();
        int n = ext.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension element = iExtensionArray[n2];
            commands.addAll(CommandFactory.createCommands(element.getConfigurationElements()));
            ++n2;
        }
        return commands;
    }

    private static List<Command> createCommands(IConfigurationElement[] configurationElements) {
        ArrayList<Command> commands = new ArrayList<Command>();
        IConfigurationElement[] iConfigurationElementArray = configurationElements;
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            if (EXTENSION_NAME.equalsIgnoreCase(configurationElement.getName())) {
                try {
                    commands.add(CommandFactory.createCommand(configurationElement));
                }
                catch (Exception e) {
                    LOGGER.severe(e.getMessage());
                }
            }
            ++n2;
        }
        return commands;
    }

    private static Command createCommand(IConfigurationElement configElement) throws Exception {
        Command command = new Command();
        CommandFactory.setIdentifier(command, configElement);
        CommandFactory.setName(command, configElement);
        CommandFactory.setDescription(command, configElement);
        CommandFactory.setClass(command, configElement);
        CommandFactory.setCategory(command, configElement);
        CommandFactory.setCommandHelper(command, configElement);
        IConfigurationElement[] iConfigurationElementArray = configElement.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement childElement = iConfigurationElementArray[n2];
            try {
                command.addParameter(CommandFactory.createParameter(childElement));
            }
            catch (Exception e) {
                throw new Exception("Error initializing command " + command.getName() + " " + e.getMessage());
            }
            ++n2;
        }
        return command;
    }

    private static void setCommandHelper(Command command, IConfigurationElement configElement) throws Exception {
        String clazz = configElement.getAttribute(COMMAND_HELPER);
        if (clazz != null && clazz.length() > 0) {
            try {
                Object o = configElement.createExecutableExtension(COMMAND_HELPER);
                if (o instanceof ICommandHelper) {
                    command.setCommandHelper((ICommandHelper)o);
                }
            }
            catch (CoreException e) {
                LOGGER.log(Level.SEVERE, "Failed to create type completion object", e);
                throw new Exception("Error creating type completion object", e);
            }
        }
    }

    private static Parameter createParameter(IConfigurationElement configElement) throws Exception {
        String type = configElement.getName();
        if (type != null) {
            HashMap<String, String> parameterPropertiess = new HashMap<String, String>();
            String[] stringArray = configElement.getAttributeNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                String value = configElement.getAttribute(name);
                parameterPropertiess.put(name, value);
                ++n2;
            }
            return new Parameter(type, parameterPropertiess);
        }
        throw new Exception("A parameter must have a type.");
    }

    private static void setClass(Command command, IConfigurationElement configElement) throws Exception {
        String clazz = configElement.getAttribute(CLASS);
        if (clazz == null) {
            throw new Exception("A command must have a class .");
        }
        command.setClassConfigurationElement(configElement);
    }

    private static void setCategory(Command command, IConfigurationElement configElement) {
        String category = configElement.getAttribute(CATEGORY);
        if (category != null) {
            command.setCategory(category);
        }
    }

    private static void setDescription(Command command, IConfigurationElement configElement) {
        String description = configElement.getAttribute(DESCRIPTION);
        if (description != null) {
            command.setDescription(description);
        }
    }

    private static void setName(Command command, IConfigurationElement configElement) {
        String name = configElement.getAttribute(NAME);
        if (name == null) {
            name = command.getIdentifier();
        }
        command.setName(name);
    }

    private static void setIdentifier(Command command, IConfigurationElement configElement) throws Exception {
        String identifier = configElement.getAttribute(IDENTIFIER);
        if (identifier == null) {
            throw new Exception("Missing command name.");
        }
        if (identifier.length() == 0) {
            throw new Exception("Command must be at least one character.");
        }
        CommandFactory.ensureValidCommandIdentifier(identifier);
        command.setIdentifier(identifier);
    }

    private static void ensureValidCommandIdentifier(String identifier) throws Exception {
        int n = 0;
        while (n < identifier.length()) {
            char c = identifier.charAt(n);
            if (!Character.isJavaIdentifierStart(c) || c == '-') {
                throw new Exception(c + " is not a valid character for a command.");
            }
            ++n;
        }
    }
}

