/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.serializers.stacktraces;

import java.util.ArrayList;
import java.util.List;
import org.openjdk.jmc.flightrecorder.stacktrace.tree.AggregatableFrame;
import org.openjdk.jmc.flightrecorder.stacktrace.tree.Node;
import org.openjdk.jmc.flightrecorder.stacktrace.tree.StacktraceTreeModel;

public class CollapsedSerializer {
    public static String toCollapsed(StacktraceTreeModel model) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> lines = new ArrayList<String>();
        CollapsedSerializer.toCollapsed(sb, lines, model, model.getRoot());
        return String.join((CharSequence)"\n", lines);
    }

    private static void toCollapsed(StringBuilder sb, List<String> lines, StacktraceTreeModel model, Node node) {
        if (!node.isRoot()) {
            CollapsedSerializer.appendFrame(sb, node.getFrame(), node.getCumulativeWeight());
        }
        if (node.getChildren().isEmpty()) {
            lines.add(sb.toString() + " " + (int)node.getCumulativeWeight());
            return;
        }
        for (Node child : node.getChildren()) {
            CollapsedSerializer.toCollapsed(new StringBuilder(sb), lines, model, child);
        }
    }

    private static void appendFrame(StringBuilder sb, AggregatableFrame frame, double value) {
        if (sb.length() > 0) {
            sb.append(";");
        }
        sb.append(frame.getHumanReadableShortString());
    }
}

