/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.configuration.model.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openjdk.jmc.flightrecorder.configuration.model.xml.XMLAttribute;
import org.openjdk.jmc.flightrecorder.configuration.model.xml.XMLNode;
import org.openjdk.jmc.flightrecorder.configuration.model.xml.XMLNodeType;

public class XMLTag
extends XMLNode {
    private final List<XMLTag> m_tags = new ArrayList<XMLTag>();
    private final List<XMLAttribute> m_attributes = new ArrayList<XMLAttribute>();

    public XMLTag(String name) {
        super(name, XMLNodeType.ELEMENT);
    }

    public XMLTag(String name, XMLNodeType type) {
        super(name, type);
    }

    public List<XMLTag> getTags() {
        return this.m_tags;
    }

    public List<XMLAttribute> getAttributes() {
        return this.m_attributes;
    }

    public void add(XMLNode ... nodes) {
        for (XMLNode node : nodes) {
            if (node instanceof XMLTag) {
                this.m_tags.add((XMLTag)node);
            }
            if (!(node instanceof XMLAttribute)) continue;
            this.m_attributes.add((XMLAttribute)node);
        }
    }

    public String toString() {
        return "Tag: " + this.getName();
    }

    public boolean accepts(Map<String, String> attributes) {
        return true;
    }

    static class Predicated
    extends XMLTag {
        private final String key;
        private final String value;

        public Predicated(String name, XMLAttribute attribute, String value) {
            super(name);
            this.key = attribute.getName();
            this.value = value;
        }

        @Override
        public boolean accepts(Map<String, String> attributes) {
            return this.value.equals(attributes.get(this.key));
        }
    }
}

