/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.configuration.model.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openjdk.jmc.flightrecorder.configuration.model.xml.XMLAttribute;
import org.openjdk.jmc.flightrecorder.configuration.model.xml.XMLAttributeInstance;
import org.openjdk.jmc.flightrecorder.configuration.model.xml.XMLNodeType;
import org.openjdk.jmc.flightrecorder.configuration.model.xml.XMLTag;

public final class XMLTagInstance {
    private final List<XMLAttributeInstance> m_attributeInstances = new ArrayList<XMLAttributeInstance>();
    private final List<XMLTagInstance> m_childElements = new ArrayList<XMLTagInstance>();
    private final XMLTag m_tag;
    private XMLTagInstance m_parent;
    private String m_content = "";

    public XMLTagInstance(XMLTagInstance parent, XMLTag tag) {
        this.m_parent = parent;
        this.m_tag = tag;
    }

    public XMLTag getTag() {
        return this.m_tag;
    }

    public List<XMLAttributeInstance> getAttributeInstances() {
        return this.m_attributeInstances;
    }

    public List<XMLTagInstance> getTagsInstances() {
        return this.m_childElements;
    }

    public XMLTagInstance getParent() {
        return this.m_parent;
    }

    public XMLTagInstance create(String tag, Map<String, String> attributes) {
        for (XMLTag xmlTag : this.getTag().getTags()) {
            if (!tag.equalsIgnoreCase(xmlTag.getName()) || !xmlTag.accepts(attributes)) continue;
            XMLTagInstance element = new XMLTagInstance(this, xmlTag);
            for (XMLAttribute attribute : xmlTag.getAttributes()) {
                XMLAttributeInstance ia = new XMLAttributeInstance(attribute);
                element.getAttributeInstances().add(ia);
                if (!attributes.containsKey(attribute.getName())) continue;
                ia.setValue(attributes.get(attribute.getName()));
            }
            this.m_childElements.add(element);
            return element;
        }
        throw new IllegalArgumentException(tag + " is not allowed under " + this.getTag().getName());
    }

    public boolean remove(XMLTagInstance child) {
        return this.m_childElements.remove(child);
    }

    public void adopt(XMLTagInstance child) {
        XMLTagInstance oldParent = child.m_parent;
        if (oldParent != this) {
            this.m_childElements.add(child);
            child.m_parent = this;
            oldParent.m_childElements.remove(child);
        }
    }

    public void setContent(String content) {
        if (content == null) {
            throw new IllegalArgumentException("Content can't be null. Use empty string if missing");
        }
        this.m_content = content;
    }

    public boolean hasContent() {
        return this.getTag().getType() == XMLNodeType.ELEMENT_WITH_CONTENT;
    }

    public XMLTagInstance create(XMLTag tag) {
        return this.create(tag.getName(), new HashMap<String, String>());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<");
        builder.append(this.getTag().getName());
        for (XMLAttributeInstance a : this.getAttributeInstances()) {
            if (a.isImplicitDefault()) continue;
            builder.append(" ");
            builder.append(a.getAttribute().getName());
            builder.append("=\"");
            builder.append(a.getValue());
            builder.append("\"");
        }
        builder.append("/>");
        return builder.toString();
    }

    public String getValue(XMLAttribute attribute) {
        for (XMLAttributeInstance i : this.m_attributeInstances) {
            if (!i.getAttribute().equals(attribute)) continue;
            return i.getValue();
        }
        throw new IllegalArgumentException("Unknown attribute '" + attribute.getName() + "' in element '" + this.getTag().getName() + "'");
    }

    public String getExplicitValue(XMLAttribute attribute) {
        for (XMLAttributeInstance i : this.m_attributeInstances) {
            if (!i.getAttribute().equals(attribute)) continue;
            return i.getExplicitValue();
        }
        throw new IllegalArgumentException("Unknown attribute '" + attribute.getName() + "' in element '" + this.getTag().getName() + "'");
    }

    public boolean setValue(XMLAttribute attribute, String newValue) {
        for (XMLAttributeInstance i : this.m_attributeInstances) {
            if (!i.getAttribute().equals(attribute)) continue;
            return i.setValue(newValue);
        }
        throw new IllegalArgumentException("Unknown attribute '" + attribute.getName() + "' in element '" + this.getTag().getName() + "'");
    }

    public List<XMLTagInstance> getTagsInstances(XMLTag tag) {
        ArrayList<XMLTagInstance> elements = new ArrayList<XMLTagInstance>();
        for (XMLTagInstance element : this.m_childElements) {
            if (element.getTag() != tag) continue;
            elements.add(element);
        }
        return elements;
    }

    public XMLTagInstance findTagWithAttribute(XMLTag tag, XMLAttribute attribute, String value) {
        for (XMLTagInstance element : this.m_childElements) {
            if (element.getTag() != tag || !value.equals(element.getValue(attribute))) continue;
            return element;
        }
        return null;
    }

    public XMLTagInstance findNestedTagWithAttribute(XMLTag recurseTag, XMLTag targetTag, XMLAttribute attribute, String value) {
        for (XMLTagInstance element : this.m_childElements) {
            XMLTagInstance result;
            XMLTag tag = element.getTag();
            if (tag == targetTag) {
                if (!value.equals(element.getValue(attribute))) continue;
                return element;
            }
            if (tag != recurseTag || (result = element.findNestedTagWithAttribute(recurseTag, targetTag, attribute, value)) == null) continue;
            return result;
        }
        return null;
    }

    public String getContent() {
        if (this.hasContent()) {
            return this.m_content;
        }
        return "";
    }
}

