/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.notification.tab;

import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.openjdk.jmc.console.ui.notification.tab.RuleGroup;
import org.openjdk.jmc.rjmx.common.subscription.IMRIService;
import org.openjdk.jmc.rjmx.triggers.TriggerRule;
import org.openjdk.jmc.rjmx.triggers.internal.NotificationRegistry;

public class RuleCheckedStateProvider
implements ICheckStateProvider,
ICheckStateListener {
    private final IMRIService mriService;
    private final String serverGuid;
    private final NotificationRegistry notificationModel;

    public RuleCheckedStateProvider(IMRIService mriService, String serverGuid, NotificationRegistry notificationModel) {
        this.mriService = mriService;
        this.serverGuid = serverGuid;
        this.notificationModel = notificationModel;
    }

    public boolean isChecked(Object element) {
        if (element instanceof TriggerRule) {
            return this.notificationModel.getRegisteredRules(this.serverGuid).contains(element);
        }
        return false;
    }

    public boolean isGrayed(Object element) {
        return false;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Object element = event.getElement();
        if (element instanceof TriggerRule) {
            this.setRuleChecked((TriggerRule)element, event.getChecked());
        } else if (element instanceof RuleGroup) {
            RuleGroup group = (RuleGroup)element;
            group.getRules().forEach(rule -> this.setRuleChecked((TriggerRule)rule, event.getChecked()));
        }
    }

    private void setRuleChecked(TriggerRule rule, boolean checked) {
        if (!checked) {
            this.unregisterRule(rule);
        } else if (this.canRegister(rule) && !this.registerRule(rule)) {
            this.unregisterRule(rule);
        }
    }

    boolean canRegister(TriggerRule rule) {
        return rule.isReady() && this.mriService != null && this.mriService.isMRIAvailable(rule.getTrigger().getAttributeDescriptor());
    }

    private void unregisterRule(TriggerRule rule) {
        this.notificationModel.unregisterRule(rule, this.serverGuid);
    }

    private boolean registerRule(TriggerRule rule) {
        return this.notificationModel.registerRule(rule, this.serverGuid);
    }
}

