/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.notification.uicomponents;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.openjdk.jmc.console.ui.notification.uicomponents.Messages;
import org.openjdk.jmc.console.ui.notification.uicomponents.TextInputItem;
import org.openjdk.jmc.rjmx.triggers.fields.internal.Field;
import org.openjdk.jmc.ui.common.CorePlugin;
import org.openjdk.jmc.ui.common.idesupport.IDESupportToolkit;
import org.openjdk.jmc.ui.common.resource.MCFile;
import org.openjdk.jmc.ui.misc.ControlDecorationToolkit;
import org.openjdk.jmc.ui.uibuilder.IUIBuilder;

public class FileInputItem
extends TextInputItem {
    public FileInputItem(Field field, IUIBuilder builder) {
        super(field, builder);
    }

    @Override
    protected void createUI() {
        this.getUIBuilder().createLabel(this.getField().getName() + ":", "");
        this.m_text = this.getUIBuilder().createText(this.getField().getValue(), this.getField().getDescription(), 0);
        Button browseButton = this.getUIBuilder().createButton(Messages.FileInputItem_BUTTON_BROWSE_TEXT, Messages.FileInputItem_BUTTON_BROWSE_TOOLTIP);
        browseButton.addSelectionListener((SelectionListener)new BrowseSelectionListener());
        this.getUIBuilder().layout();
        final ControlDecoration infoDecorator = ControlDecorationToolkit.createDecorator((Control)this.m_text, (int)131200, (String)"DEC_INFORMATION");
        infoDecorator.setShowOnlyOnFocus(false);
        this.m_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IStatus validateFile = IDESupportToolkit.validateFileResourcePath((String)FileInputItem.this.m_text.getText());
                if (validateFile.isOK()) {
                    infoDecorator.hide();
                } else {
                    infoDecorator.setDescriptionText(validateFile.getMessage());
                    infoDecorator.show();
                }
            }
        });
        this.m_text.setText(this.getField().getValue());
    }

    private final class BrowseSelectionListener
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            MCFile file = this.onBrowse();
            if (file != null) {
                FileInputItem.this.getField().setValue(file.getPath());
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        private MCFile onBrowse() {
            return CorePlugin.getDefault().getIDESupport().browseForSaveAsFile(NLS.bind((String)Messages.FileInputItem_SELECT_FIELD_TEXT, (Object)FileInputItem.this.getField().getName()), FileInputItem.this.getField().getValue(), null, "");
        }
    }
}

