/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.descriptors;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.logging.Logger;
import org.openjdk.jmc.joverflow.descriptors.AbstractCollectionDescriptor;
import org.openjdk.jmc.joverflow.descriptors.ArrayBasedCollectionDescriptor;
import org.openjdk.jmc.joverflow.descriptors.ArrayDequeDescriptor;
import org.openjdk.jmc.joverflow.descriptors.CollectionClassDescriptor;
import org.openjdk.jmc.joverflow.descriptors.CollectionInstanceDescriptor;
import org.openjdk.jmc.joverflow.descriptors.ConcurrentHashMapDescriptor;
import org.openjdk.jmc.joverflow.descriptors.ConcurrentHashMapDescriptorForJdk8;
import org.openjdk.jmc.joverflow.descriptors.CopyOnWriteArraySetDescriptor;
import org.openjdk.jmc.joverflow.descriptors.FullyUtilizedArrayListDescriptor;
import org.openjdk.jmc.joverflow.descriptors.HashSetDescriptor;
import org.openjdk.jmc.joverflow.descriptors.IdentityHashMapDescriptor;
import org.openjdk.jmc.joverflow.descriptors.LinkedCollectionDescriptor;
import org.openjdk.jmc.joverflow.descriptors.LinkedHashMapDescriptor;
import org.openjdk.jmc.joverflow.descriptors.StandaloneArrayDescFactory;
import org.openjdk.jmc.joverflow.descriptors.TreeMapDescriptor;
import org.openjdk.jmc.joverflow.descriptors.WeakHashMapDescriptor;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaLazyReadObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObjectArray;
import org.openjdk.jmc.joverflow.heap.model.JavaValueArray;
import org.openjdk.jmc.joverflow.heap.model.Snapshot;
import org.openjdk.jmc.joverflow.support.Constants;
import org.openjdk.jmc.joverflow.util.ClassUtils;

public class CollectionDescriptors
implements Constants {
    private static final Logger LOGGER = Logger.getLogger("org.openjdk.jmc.joverflow.descriptors");
    private static final String[] EMPTY_STRS = new String[0];
    private static final JavaClass[] EMPTY_CLZ = new JavaClass[0];
    private final HashMap<String, AbstractCollectionDescriptor.Factory> colDescs;
    private final Snapshot snapshot;
    private final boolean JDK8_HASHMAP;

    private boolean isJdk8HashMap() {
        JavaClass clazz = this.snapshot.getClassForName("java.util.HashMap");
        return clazz.getStaticField("ALTERNATIVE_HASHING_THRESHOLD_DEFAULT") == null;
    }

    public CollectionDescriptors(Snapshot snapshot) {
        this.snapshot = snapshot;
        CollectionDescriptors.setBannedFields(snapshot);
        this.colDescs = new HashMap();
        this.JDK8_HASHMAP = this.isJdk8HashMap();
        this.initDescFactories();
        this.createDescFactoriesForSubclasses();
    }

    public CollectionInstanceDescriptor getDescriptor(JavaObject col) {
        AbstractCollectionDescriptor.Factory factory = this.colDescs.get(col.getClazz().getName());
        if (factory == null) {
            return null;
        }
        return factory.get(col);
    }

    public CollectionClassDescriptor getClassDescriptor(JavaObject col) {
        return this.getClassDescriptor(col.getClazz().getName());
    }

    public CollectionClassDescriptor getClassDescriptor(String clazzName) {
        AbstractCollectionDescriptor.Factory factory = this.colDescs.get(clazzName);
        if (factory == null) {
            return null;
        }
        return factory.getClassDescriptor();
    }

    public CollectionClassDescriptor getStandaloneArrayDescriptor(JavaLazyReadObject ar) {
        if (!(ar instanceof JavaObjectArray) && !(ar instanceof JavaValueArray)) {
            throw new IllegalArgumentException("Argument of non-array type " + String.valueOf(ar.getClass()));
        }
        String clazzName = ar.getClazz().getName();
        StandaloneArrayDescFactory factory = (StandaloneArrayDescFactory)this.colDescs.get(clazzName);
        if (factory == null) {
            factory = new StandaloneArrayDescFactory(ar.getClazz());
            this.colDescs.put(clazzName, factory);
        }
        return factory.getClassDescriptor();
    }

    public ArrayList<CollectionClassDescriptor> getOverheadsByClass() {
        long lastElOvhd;
        ArrayList<CollectionClassDescriptor> result = new ArrayList<CollectionClassDescriptor>();
        for (AbstractCollectionDescriptor.Factory factory : this.colDescs.values()) {
            result.add(factory.getClassDescriptor());
        }
        result.sort(new Comparator<CollectionClassDescriptor>(){

            @Override
            public int compare(CollectionClassDescriptor d1, CollectionClassDescriptor d2) {
                long o2;
                long o1 = d1.getTotalOverhead();
                if (o1 > (o2 = d2.getTotalOverhead())) {
                    return -1;
                }
                if (o1 < o2) {
                    return 1;
                }
                return 0;
            }
        });
        while ((lastElOvhd = ((CollectionClassDescriptor)result.get(result.size() - 1)).getTotalOverhead()) == 0L) {
            result.remove(result.size() - 1);
        }
        return result;
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    private void initDescFactories() {
        this.colDescs.put("java.util.HashMap", this.newHashMapDescFactory());
        this.colDescs.put("java.util.LinkedHashMap", this.newLinkedHashMapDescFactory());
        JavaClass clazz = this.snapshot.getClassForName("java.util.HashSet");
        if (clazz != null) {
            this.colDescs.put("java.util.HashSet", this.hashSetDescriptorFactory(clazz));
        }
        if ((clazz = this.snapshot.getClassForName("java.util.LinkedHashSet")) != null) {
            this.colDescs.put("java.util.LinkedHashSet", this.linkedHashSetDescriptorFactory(clazz));
        }
        this.addArrayBasedDescFactory("java.util.ArrayList", false, "size", "elementData|array", 10, EMPTY_STRS);
        this.addArrayBasedDescFactory("java.util.Vector", false, "elementCount", "elementData", 10, EMPTY_STRS);
        this.addArrayBasedDescFactory("java.util.StaNonFinalck", false, "elementCount", "elementData", 10, EMPTY_STRS);
        this.addArrayBasedDescFactory("java.util.Hashtable", true, "count|size", "table", 11, new String[]{"java.util.Hashtable$Entry", ClassUtils.arrayOf("java.util.Hashtable$Entry")});
        this.addArrayBasedDescFactory("java.util.Properties", true, "count|size", "table", 11, new String[]{"java.util.Hashtable$Entry", ClassUtils.arrayOf("java.util.Hashtable$Entry")});
        clazz = this.snapshot.getClassForName("java.util.concurrent.ConcurrentHashMap");
        if (clazz != null) {
            this.putConcurrentHashMap(clazz);
        }
        if ((clazz = this.snapshot.getClassForName("java.util.WeakHashMap")) != null) {
            this.colDescs.put("java.util.WeakHashMap", new WeakHashMapDescriptor.Factory(clazz, this.getClassesForNames(new String[]{"java.util.WeakHashMap$Entry", ClassUtils.arrayOf("java.util.WeakHashMap$Entry")})));
        }
        if ((clazz = this.snapshot.getClassForName("java.util.TreeMap")) != null) {
            String[] entryClass = this.snapshot.getClassForName("java.util.TreeMap$Entry") != null ? new String[]{"java.util.TreeMap$Entry"} : (this.snapshot.getClassForName("java.util.TreeMap$Node") != null ? new String[]{"java.util.TreeMap$Node"} : new String[]{});
            this.colDescs.put("java.util.TreeMap", new TreeMapDescriptor.Factory(clazz, this.getClassesForNames(entryClass)));
        }
        boolean isNewLinkedList = this.snapshot.getClassForName("java.util.LinkedList$Node") != null;
        this.addLinkedListDescFactory("java.util.LinkedList", "size", "header|first|voidLink", "element|item|data", new String[]{isNewLinkedList ? "java.util.LinkedList$Node" : "java.util.LinkedList$Entry"});
        clazz = this.snapshot.getClassForName("java.util.IdentityHashMap");
        if (clazz != null) {
            this.colDescs.put("java.util.IdentityHashMap", new IdentityHashMapDescriptor.Factory(clazz));
        }
        this.addArrayBasedDescFactory("java.util.concurrent.ArrayBlockingQueue", false, "count", "items", 0, EMPTY_STRS);
        clazz = this.snapshot.getClassForName("java.util.ArrayDeque");
        if (clazz != null) {
            this.colDescs.put("java.util.ArrayDeque", new ArrayDequeDescriptor.Factory(clazz));
        }
        this.addArrayBasedDescFactory("javax.management.AttributeList", false, "size", "elementData", 10, EMPTY_STRS);
        this.addLinkedListDescFactory("java.util.concurrent.ConcurrentLinkedQueue", null, "head", "item", new String[]{"java.util.concurrent.ConcurrentLinkedQueue$Node"});
        if (this.snapshot.getClassForName("java.util.concurrent.CopyOnWriteArrayList") != null) {
            this.colDescs.put("java.util.concurrent.CopyOnWriteArrayList", this.newCopyOnWriteArrayListFactory());
        }
        if ((clazz = this.snapshot.getClassForName("java.util.concurrent.CopyOnWriteArraySet")) != null) {
            this.colDescs.put("java.util.concurrent.CopyOnWriteArraySet", new CopyOnWriteArraySetDescriptor.Factory(clazz, this.newCopyOnWriteArrayListFactory()));
        }
        this.addArrayBasedDescFactory("java.util.PriorityQueue", false, "size", "queue", 11, EMPTY_STRS);
    }

    private ArrayBasedCollectionDescriptor.Factory addArrayBasedDescFactory(String className, boolean isMap, String sizeFieldName, String elsArrayFieldName, int defaultInitialCapacity, String[] implClassNames) {
        JavaClass clazz = this.snapshot.getClassForName(className);
        if (clazz == null) {
            return null;
        }
        sizeFieldName = ClassUtils.getExactFieldName(sizeFieldName, clazz);
        elsArrayFieldName = ClassUtils.getExactFieldName(elsArrayFieldName, clazz);
        ArrayBasedCollectionDescriptor.Factory factory = new ArrayBasedCollectionDescriptor.Factory(clazz, isMap, sizeFieldName, elsArrayFieldName, defaultInitialCapacity, this.getClassesForNames(implClassNames), null);
        this.colDescs.put(className, factory);
        return factory;
    }

    private void addLinkedListDescFactory(String className, String sizeFieldName, String rootFieldName, String elementFieldName, String[] implClassNames) {
        JavaClass clazz = this.snapshot.getClassForName(className);
        if (clazz == null) {
            return;
        }
        rootFieldName = ClassUtils.getExactFieldName(rootFieldName, clazz);
        this.colDescs.put(className, new LinkedCollectionDescriptor.Factory(clazz, sizeFieldName, rootFieldName, elementFieldName, this.getClassesForNames(implClassNames)));
    }

    private ArrayBasedCollectionDescriptor.Factory newHashMapDescFactory() {
        JavaClass clazz = this.snapshot.getClassForName("java.util.HashMap");
        if (clazz == null) {
            return null;
        }
        String implClassName = this.JDK8_HASHMAP ? "java.lang.Object" : "java.util.HashMap$Entry";
        return new ArrayBasedCollectionDescriptor.Factory(clazz, true, "size", "table", 16, this.getClassesForNames(new String[]{implClassName, ClassUtils.arrayOf(implClassName)}), new String[]{"java.util.HashSet"}, this.JDK8_HASHMAP);
    }

    private ArrayBasedCollectionDescriptor.Factory newLinkedHashMapDescFactory() {
        JavaClass clazz = this.snapshot.getClassForName("java.util.LinkedHashMap");
        if (clazz == null) {
            return null;
        }
        String implClassName = this.JDK8_HASHMAP ? "java.lang.Object" : "java.util.HashMap$Entry";
        return new LinkedHashMapDescriptor.Factory(clazz, this.getClassesForNames(new String[]{"java.util.LinkedHashMap$Entry", ClassUtils.arrayOf(implClassName)}), this.JDK8_HASHMAP);
    }

    private HashSetDescriptor.Factory hashSetDescriptorFactory(JavaClass clazz) {
        String implClassName = this.JDK8_HASHMAP ? "java.lang.Object" : "java.util.HashMap$Entry";
        return new HashSetDescriptor.Factory(clazz, this.getClassesForNames(new String[]{"java.util.HashMap", implClassName, ClassUtils.arrayOf(implClassName)}), this.newHashMapDescFactory());
    }

    private HashSetDescriptor.Factory linkedHashSetDescriptorFactory(JavaClass clazz) {
        String implClassName = this.JDK8_HASHMAP ? "java.lang.Object" : "java.util.HashMap$Entry";
        return new HashSetDescriptor.Factory(clazz, this.getClassesForNames(new String[]{"java.util.LinkedHashMap", "java.util.LinkedHashMap$Entry", ClassUtils.arrayOf(implClassName)}), this.newLinkedHashMapDescFactory());
    }

    private void putConcurrentHashMap(JavaClass clazz) {
        JavaClass chmNodeClazz = this.snapshot.getClassForName("java.util.concurrent.ConcurrentHashMap$Node");
        if (!this.JDK8_HASHMAP || chmNodeClazz == null) {
            JavaClass chmSegmentClazz = this.snapshot.getClassForName("java.util.concurrent.ConcurrentHashMap$Segment");
            this.colDescs.put("java.util.concurrent.ConcurrentHashMap", new ConcurrentHashMapDescriptor.Factory(clazz, chmSegmentClazz, this.getClassesForNames(new String[]{"java.util.concurrent.ConcurrentHashMap$Segment", "java.util.concurrent.ConcurrentHashMap$HashEntry", ClassUtils.arrayOf("java.util.concurrent.ConcurrentHashMap$Segment"), ClassUtils.arrayOf("java.util.concurrent.ConcurrentHashMap$HashEntry")})));
        } else {
            this.colDescs.put("java.util.concurrent.ConcurrentHashMap", new ConcurrentHashMapDescriptorForJdk8.Factory(clazz, chmNodeClazz, this.getClassesForNames(new String[]{"java.util.concurrent.ConcurrentHashMap$Node", ClassUtils.arrayOf("java.util.concurrent.ConcurrentHashMap$Node")})));
        }
    }

    private FullyUtilizedArrayListDescriptor.Factory newCopyOnWriteArrayListFactory() {
        JavaClass clazz = this.snapshot.getClassForName("java.util.concurrent.CopyOnWriteArrayList");
        return new FullyUtilizedArrayListDescriptor.Factory(clazz, "array", EMPTY_CLZ, new String[]{"java.util.concurrent.CopyOnWriteArraySet"});
    }

    private void createDescFactoriesForSubclasses() {
        JavaClass[] classes;
        JavaClass[] javaClassArray = classes = this.snapshot.getClasses();
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            JavaClass clazz = javaClassArray[n2];
            String className = clazz.getName();
            if (!this.colDescs.containsKey(className)) {
                JavaClass superclazz = clazz.getSuperclass();
                while (superclazz != null) {
                    String superName = superclazz.getName();
                    AbstractCollectionDescriptor.Factory superclassFactory = this.colDescs.get(superName);
                    if (superclassFactory != null) {
                        this.colDescs.put(className, superclassFactory.cloneForSubclass(clazz));
                        break;
                    }
                    superclazz = superclazz.getSuperclass();
                }
            }
            ++n2;
        }
    }

    private static void setBannedFields(Snapshot snapshot) {
        JavaClass.setFieldBanned(snapshot.getClassForName("java.util.LinkedHashMap"), "header");
        JavaClass.setFieldBanned(snapshot.getClassForName("java.util.LinkedHashMap$Entry"), "before");
        JavaClass.setFieldBanned(snapshot.getClassForName("java.util.LinkedHashMap$Entry"), "after");
        JavaClass.setFieldBanned(snapshot.getClassForName("java.util.LinkedList"), "last");
        JavaClass.setFieldBanned(snapshot.getClassForName("java.util.concurrent.ConcurrentLinkedQueue"), "tail");
        JavaClass.setFieldBanned(snapshot.getClassForName("java.util.WeakHashMap$Entry"), "next");
    }

    private JavaClass[] getClassesForNames(String[] classNames) {
        ArrayList<JavaClass> clazzes = new ArrayList<JavaClass>(classNames.length);
        int i = 0;
        while (i < classNames.length) {
            JavaClass clazz = this.snapshot.getClassForName(classNames[i]);
            if (clazz == null) {
                if (classNames[i].equals("java.util.HashMap$Entry")) {
                    clazz = this.snapshot.getClassForName("java.util.HashMap$HashMapEntry");
                } else if (classNames[i].equals("[Ljava.util.HashMap$Entry;")) {
                    clazz = this.snapshot.getClassForName("java.util.HashMap$Entry[]");
                    if (clazz == null) {
                        clazz = this.snapshot.getClassForName("java.util.HashMap$HashMapEntry[]");
                    }
                } else if (classNames[i].equals("java.util.Hashtable$Entry")) {
                    clazz = this.snapshot.getClassForName("java.util.Hashtable$HashtableEntry");
                } else if (classNames[i].equals("[Ljava.util.Hashtable$Entry;") && (clazz = this.snapshot.getClassForName("java.util.Hashtable$Entry[]")) == null) {
                    clazz = this.snapshot.getClassForName("java.util.Hashtable$HashtableEntry[]");
                }
                if (classNames[i].equals("java.util.LinkedHashMap$Entry")) {
                    clazz = this.snapshot.getClassForName("java.util.LinkedHashMap$LinkedEntry");
                } else if (classNames[i].equals("[Ljava.util.LinkedHashMap$Entry;")) {
                    clazz = this.snapshot.getClassForName("java.util.LinkedHashMap$LinkedEntry[]");
                } else if (classNames[i].equals("[Ljava.util.concurrent.ConcurrentHashMap$HashEntry;")) {
                    clazz = this.snapshot.getClassForName("java.util.concurrent.ConcurrentHashMap$HashEntry[]");
                } else if (classNames[i].equals("[Ljava.util.concurrent.ConcurrentHashMap$Segment;")) {
                    clazz = this.snapshot.getClassForName("java.util.concurrent.ConcurrentHashMap$Segment[]");
                } else if (classNames[i].equals("[Ljava.util.WeakHashMap$Entry;")) {
                    clazz = this.snapshot.getClassForName("java.util.WeakHashMap$Entry[]");
                } else if (classNames[i].equals("java.util.LinkedList$Entry") && (clazz = this.snapshot.getClassForName("java.util.LinkedList$Link")) == null) {
                    clazz = this.snapshot.getClassForName("java.util.LinkedList$ListItr");
                }
                if (clazz == null) {
                    LOGGER.severe("CollectionDescriptors: Class " + classNames[i] + " not found");
                }
            }
            if (clazz != null) {
                clazzes.add(clazz);
            }
            ++i;
        }
        return clazzes.toArray(new JavaClass[clazzes.size()]);
    }
}

