/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.heap.model;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import org.openjdk.jmc.joverflow.heap.model.ArrayTypeCodes;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaHeapObjectVisitor;
import org.openjdk.jmc.joverflow.heap.model.JavaLazyReadObject;
import org.openjdk.jmc.joverflow.heap.model.Snapshot;
import org.openjdk.jmc.joverflow.heap.parser.DumpCorruptedException;
import org.openjdk.jmc.joverflow.heap.parser.ReadBuffer;
import org.openjdk.jmc.joverflow.util.MiscUtils;
import org.openjdk.jmc.joverflow.util.StringInterner;

public class JavaValueArray
extends JavaLazyReadObject
implements ArrayTypeCodes {
    private final int length;

    public JavaValueArray(JavaClass clazz, long objOfsInFile, int length, int[] dataChunk, int startPosInChunk, int globalObjectIndex) {
        super(clazz, objOfsInFile, dataChunk, startPosInChunk, globalObjectIndex);
        this.length = length;
    }

    @Override
    public final int getSize() {
        JavaClass clz = this.getClazz();
        return MiscUtils.getAlignedObjectSize(JavaValueArray.elementSize(this.getElementType()) * this.length + clz.getArrayHeaderSize(), clz.getObjectAlignment());
    }

    @Override
    public final int getImplInclusiveSize() {
        return this.getSize();
    }

    public final char getElementType() {
        String clazzName = this.getClazz().getName();
        return clazzName.charAt(clazzName.length() - 1);
    }

    public final int getElementSize() {
        return JavaValueArray.elementSize(this.getElementType());
    }

    @Override
    protected final byte[] readValue() throws IOException {
        if (this.length == 0) {
            return Snapshot.EMPTY_BYTE_ARRAY;
        }
        ReadBuffer buf = this.clazz.getReadBuffer();
        int idSize = this.clazz.getHprofPointerSize();
        long offset = this.getObjOfsInFile() + (long)idSize + 9L;
        int sizeInBytes = this.length * JavaValueArray.elementSize(this.getElementType());
        byte[] res = new byte[sizeInBytes];
        try {
            buf.get(offset, res);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new DumpCorruptedException.Runtime("primitive array size for " + this.getClazz().getHumanFriendlyName() + " array ID " + MiscUtils.toHex(this.readId()) + " at offset " + this.getObjOfsInFile() + " is " + this.length + " bytes, which exceeds heap dump file size");
        }
        return res;
    }

    public final int readValue(byte[] value) {
        if (this.length == 0) {
            return 0;
        }
        try {
            ReadBuffer buf = this.clazz.getReadBuffer();
            int idSize = this.clazz.getHprofPointerSize();
            long offset = this.getObjOfsInFile() + (long)idSize + 9L;
            int sizeInBytes = this.length * JavaValueArray.elementSize(this.getElementType());
            if (sizeInBytes > value.length) {
                return sizeInBytes;
            }
            buf.get(offset, value, sizeInBytes);
            return sizeInBytes;
        }
        catch (IOException ex) {
            throw new DumpCorruptedException.Runtime("exception caught: " + String.valueOf(ex));
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new DumpCorruptedException.Runtime("primitive array size for " + this.getClazz().getHumanFriendlyName() + " array ID " + MiscUtils.toHex(this.readId()) + " at offset " + this.getObjOfsInFile() + " is " + this.length + " bytes, which exceeds heap dump file size");
        }
    }

    @Override
    public void visitReferencedObjects(JavaHeapObjectVisitor v) {
        super.visitReferencedObjects(v);
    }

    public int getLength() {
        return this.length;
    }

    public Object getElements() {
        int len = this.getLength();
        char et = this.getElementType();
        byte[] data = this.getValue();
        int index = 0;
        switch (et) {
            case 'Z': {
                boolean[] res = new boolean[len];
                int i = 0;
                while (i < len) {
                    res[i] = JavaValueArray.booleanAt(index, data);
                    ++index;
                    ++i;
                }
                return res;
            }
            case 'B': {
                byte[] res = new byte[len];
                int i = 0;
                while (i < len) {
                    res[i] = JavaValueArray.byteAt(index, data);
                    ++index;
                    ++i;
                }
                return res;
            }
            case 'C': {
                char[] res = new char[len];
                int i = 0;
                while (i < len) {
                    res[i] = JavaValueArray.charAt(index, data);
                    index += 2;
                    ++i;
                }
                return res;
            }
            case 'S': {
                short[] res = new short[len];
                int i = 0;
                while (i < len) {
                    res[i] = JavaValueArray.shortAt(index, data);
                    index += 2;
                    ++i;
                }
                return res;
            }
            case 'I': {
                int[] res = new int[len];
                int i = 0;
                while (i < len) {
                    res[i] = JavaValueArray.intAt(index, data);
                    index += 4;
                    ++i;
                }
                return res;
            }
            case 'J': {
                long[] res = new long[len];
                int i = 0;
                while (i < len) {
                    res[i] = JavaValueArray.longAt(index, data);
                    index += 8;
                    ++i;
                }
                return res;
            }
            case 'F': {
                float[] res = new float[len];
                int i = 0;
                while (i < len) {
                    res[i] = JavaValueArray.floatAt(index, data);
                    index += 4;
                    ++i;
                }
                return res;
            }
            case 'D': {
                double[] res = new double[len];
                int i = 0;
                while (i < len) {
                    res[i] = JavaValueArray.doubleAt(index, data);
                    index += 8;
                    ++i;
                }
                return res;
            }
        }
        throw new RuntimeException("unknown primitive type?");
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.getLength()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
    }

    private void requireType(char type) {
        if (this.getElementType() != type) {
            throw new RuntimeException("not of type : " + type);
        }
    }

    public boolean getBooleanAt(int index) {
        this.checkIndex(index);
        this.requireType('Z');
        return JavaValueArray.booleanAt(index, this.getValue());
    }

    public byte getByteAt(int index) {
        this.checkIndex(index);
        this.requireType('B');
        return JavaValueArray.byteAt(index, this.getValue());
    }

    public char getCharAt(int index) {
        this.checkIndex(index);
        this.requireType('C');
        return JavaValueArray.charAt(index << 1, this.getValue());
    }

    public short getShortAt(int index) {
        this.checkIndex(index);
        this.requireType('S');
        return JavaValueArray.shortAt(index << 1, this.getValue());
    }

    public int getIntAt(int index) {
        this.checkIndex(index);
        this.requireType('I');
        return JavaValueArray.intAt(index << 2, this.getValue());
    }

    public long getLongAt(int index) {
        this.checkIndex(index);
        this.requireType('J');
        return JavaValueArray.longAt(index << 3, this.getValue());
    }

    public float getFloatAt(int index) {
        this.checkIndex(index);
        this.requireType('F');
        return JavaValueArray.floatAt(index << 2, this.getValue());
    }

    public double getDoubleAt(int index) {
        this.checkIndex(index);
        this.requireType('D');
        return JavaValueArray.doubleAt(index << 3, this.getValue());
    }

    @Override
    public String valueAsString() {
        return this.valueAsString(false);
    }

    public String valueAsString(boolean bigLimit) {
        byte[] value = this.getValue();
        char elementSignature = this.getElementType();
        int elSize = JavaValueArray.elementSize(elementSignature);
        int limit = bigLimit ? 1000 : (elementSignature == 'C' ? 32 : 10);
        StringBuilder result = new StringBuilder(limit * 8);
        result.append(JavaValueArray.getElementTypeName(elementSignature)).append('[');
        result.append(value.length / elSize).append(']');
        int i = 1;
        while (i < this.getClazz().getNumArrayDimensions()) {
            result.append("[]");
            ++i;
        }
        result.append('{');
        int num = 0;
        int i2 = 0;
        while (i2 < value.length) {
            if (num > 0 && elementSignature != 'C') {
                result.append(", ");
            }
            if (num >= limit || result.length() > 74) {
                result.append(" ...");
                break;
            }
            ++num;
            switch (elementSignature) {
                case 'C': {
                    result.append(JavaValueArray.charAsString(JavaValueArray.charAt(i2, value)));
                    break;
                }
                case 'Z': {
                    result.append(JavaValueArray.booleanAsString(JavaValueArray.booleanAt(i2, value)));
                    break;
                }
                case 'B': {
                    result.append(JavaValueArray.byteAsString(JavaValueArray.byteAt(i2, value)));
                    break;
                }
                case 'S': {
                    result.append(JavaValueArray.shortAt(i2, value));
                    break;
                }
                case 'I': {
                    result.append(JavaValueArray.intAt(i2, value));
                    break;
                }
                case 'J': {
                    result.append(JavaValueArray.longAt(i2, value));
                    break;
                }
                case 'F': {
                    result.append(JavaValueArray.floatAt(i2, value));
                    break;
                }
                case 'D': {
                    result.append(JavaValueArray.doubleAt(i2, value));
                    break;
                }
                default: {
                    throw new RuntimeException("unknown primitive type?");
                }
            }
            i2 += elSize;
        }
        result.append('}');
        return StringInterner.internString(result.toString());
    }

    public static String getElementTypeName(char sig) {
        switch (sig) {
            case 'B': {
                return "byte";
            }
            case 'Z': {
                return "boolean";
            }
            case 'C': {
                return "char";
            }
            case 'S': {
                return "short";
            }
            case 'I': {
                return "int";
            }
            case 'F': {
                return "float";
            }
            case 'J': {
                return "long";
            }
            case 'D': {
                return "double";
            }
        }
        return null;
    }

    public String[] getValuesAsStrings() {
        int len = this.getLength();
        char et = this.getElementType();
        byte[] data = this.getValue();
        String[] res = new String[len];
        int index = 0;
        switch (et) {
            case 'Z': {
                int i = 0;
                while (i < len) {
                    res[i] = StringInterner.internString(JavaValueArray.booleanAsString(JavaValueArray.booleanAt(index, data)));
                    ++index;
                    ++i;
                }
                return res;
            }
            case 'B': {
                int i = 0;
                while (i < len) {
                    res[i] = StringInterner.internString(JavaValueArray.byteAsString(JavaValueArray.byteAt(index, data)));
                    ++index;
                    ++i;
                }
                return res;
            }
            case 'C': {
                int i = 0;
                while (i < len) {
                    res[i] = StringInterner.internString(JavaValueArray.charAsString(JavaValueArray.charAt(index, data)));
                    index += 2;
                    ++i;
                }
                return res;
            }
            case 'S': {
                int i = 0;
                while (i < len) {
                    res[i] = StringInterner.internString(String.valueOf(JavaValueArray.shortAt(index, data)));
                    index += 2;
                    ++i;
                }
                return res;
            }
            case 'I': {
                int i = 0;
                while (i < len) {
                    res[i] = StringInterner.internString(String.valueOf(JavaValueArray.intAt(index, data)));
                    index += 4;
                    ++i;
                }
                return res;
            }
            case 'J': {
                int i = 0;
                while (i < len) {
                    res[i] = StringInterner.internString(String.valueOf(JavaValueArray.longAt(index, data)));
                    index += 8;
                    ++i;
                }
                return res;
            }
            case 'F': {
                int i = 0;
                while (i < len) {
                    res[i] = StringInterner.internString(String.valueOf(JavaValueArray.floatAt(index, data)));
                    index += 4;
                    ++i;
                }
                return res;
            }
            case 'D': {
                int i = 0;
                while (i < len) {
                    res[i] = StringInterner.internString(String.valueOf(JavaValueArray.doubleAt(index, data)));
                    index += 8;
                    ++i;
                }
                return res;
            }
        }
        throw new RuntimeException("unknown primitive type?");
    }

    private static int elementSize(char sig) {
        switch (sig) {
            case 'B': 
            case 'Z': {
                return 1;
            }
            case 'C': 
            case 'S': {
                return 2;
            }
            case 'F': 
            case 'I': {
                return 4;
            }
            case 'D': 
            case 'J': {
                return 8;
            }
        }
        throw new RuntimeException("invalid array element type: " + sig);
    }

    private static String charAsString(char val) {
        if (val > ' ') {
            return String.valueOf(val);
        }
        return "\\0x" + Integer.toString(val, 16);
    }

    private static String booleanAsString(boolean val) {
        return val ? "true" : "false";
    }

    private static String byteAsString(byte val) {
        int intVal = 0xFF & val;
        return "0x" + Integer.toString(intVal, 16);
    }
}

