/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.stats;

import java.util.HashMap;
import org.openjdk.jmc.joverflow.descriptors.CollectionDescriptors;
import org.openjdk.jmc.joverflow.descriptors.CollectionInstanceDescriptor;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaHeapObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObject;
import org.openjdk.jmc.joverflow.heap.model.JavaThing;
import org.openjdk.jmc.joverflow.heap.model.Snapshot;

class SystemPropertiesReader {
    SystemPropertiesReader() {
    }

    static HashMap<String, String> readProperties(Snapshot snapshot, CollectionDescriptors colDesriptors) {
        JavaClass systemClazz = snapshot.getClassForName("java.lang.System");
        JavaThing propsThing = systemClazz.getStaticField("props");
        if (propsThing == null && (propsThing = SystemPropertiesReader.findFieldOfTypeProperties(systemClazz)) == null) {
            return null;
        }
        if (!(propsThing instanceof JavaObject)) {
            return null;
        }
        CollectionInstanceDescriptor colDesc = colDesriptors.getDescriptor((JavaObject)propsThing);
        if (colDesc == null || !colDesc.getClassDescriptor().isMap()) {
            return null;
        }
        final HashMap<String, String> result = new HashMap<String, String>(32);
        colDesc.iterateMap(new CollectionInstanceDescriptor.MapIteratorCallback(){

            @Override
            public boolean scanMapEntry(JavaHeapObject key, JavaHeapObject value) {
                String keyStr = key != null ? key.valueAsString() : "Unresolved object";
                String valueStr = value != null ? value.valueAsString() : "Unresolved object";
                result.put(keyStr, valueStr);
                return true;
            }

            @Override
            public boolean scanImplementationObject(JavaHeapObject implObj) {
                return true;
            }
        });
        return result;
    }

    private static JavaThing findFieldOfTypeProperties(JavaClass clazz) {
        JavaThing[] staticFields;
        JavaThing[] javaThingArray = staticFields = clazz.getStaticValues();
        int n = staticFields.length;
        int n2 = 0;
        while (n2 < n) {
            String className;
            JavaThing field = javaThingArray[n2];
            if (field instanceof JavaObject && (className = ((JavaObject)field).getClazz().getName()).equals("java.lang.Properties")) {
                return field;
            }
            ++n2;
        }
        return null;
    }
}

