/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.persistence.internal;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import java.util.Set;
import java.util.logging.Level;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.common.util.StringToolkit;
import org.openjdk.jmc.common.xydata.ITimestampedData;
import org.openjdk.jmc.rjmx.RJMXPlugin;
import org.openjdk.jmc.rjmx.common.services.IAttributeStorage;
import org.openjdk.jmc.rjmx.common.services.MRIDataSeries;
import org.openjdk.jmc.rjmx.common.services.internal.IAttributeStorageService;
import org.openjdk.jmc.rjmx.common.subscription.IMRIService;
import org.openjdk.jmc.rjmx.common.subscription.MRI;
import org.openjdk.jmc.rjmx.persistence.internal.PersistenceFile;
import org.openjdk.jmc.rjmx.preferences.PreferencesKeys;

public class PersistenceReader
implements IMRIService,
IAttributeStorageService {
    private final Map<MRI, PersistenceStorage> storages = new HashMap<MRI, PersistenceStorage>();

    public PersistenceReader(File directory, String uid) {
        File[] pFiles;
        if (directory == null) {
            directory = PersistenceReader.getPersistenceDirectoryPreference();
        }
        if (uid != null) {
            directory = new File(directory, StringToolkit.encodeFilename((String)uid));
        }
        if (directory.isDirectory() && (pFiles = directory.listFiles()) != null) {
            File[] fileArray = pFiles;
            int n = pFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File attributeDir = fileArray[n2];
                this.extractFromAttributeDir(attributeDir);
                ++n2;
            }
        }
    }

    private void extractFromAttributeDir(File attributeDir) {
        MRI mri;
        if (!attributeDir.isDirectory()) {
            return;
        }
        try {
            mri = MRI.createFromQualifiedName((String)URLDecoder.decode(attributeDir.getName(), StandardCharsets.UTF_8));
        }
        catch (IllegalArgumentException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not create MRI from directory name " + attributeDir.getName(), e);
            return;
        }
        ArrayList<PersistenceFile> files = new ArrayList<PersistenceFile>();
        File[] listFiles = attributeDir.listFiles(PersistenceFile.FILTER);
        if (listFiles != null) {
            File[] fileArray = listFiles;
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                try {
                    PersistenceFile pf = new PersistenceFile(f);
                    if (pf.eventCount > 0) {
                        files.add(pf);
                    }
                }
                catch (Exception e) {
                    RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not add file " + f.getPath(), e);
                }
                ++n2;
            }
        }
        files.sort(PersistenceFile.PERSISTENCE_FILE_START_COMPARATOR);
        ArrayList<Long> seriesStart = new ArrayList<Long>();
        DataInputStream seriesFileStream = null;
        File seriesFile = new File(attributeDir, "series.info");
        try {
            try {
                seriesFileStream = new DataInputStream(new BufferedInputStream(new FileInputStream(seriesFile)));
                while (seriesFileStream.available() > 0) {
                    seriesStart.add(seriesFileStream.readLong());
                }
            }
            catch (IOException e) {
                RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Error while reading persisted data from file " + seriesFile.getPath(), e);
                IOToolkit.closeSilently((Closeable)seriesFileStream);
                return;
            }
        }
        catch (Throwable e) {
            IOToolkit.closeSilently(seriesFileStream);
            throw e;
        }
        IOToolkit.closeSilently((Closeable)seriesFileStream);
        PersistenceStorage storage = new PersistenceStorage();
        if (seriesStart.isEmpty()) {
            storage.series.add(new PersistentMRIDataSeries(mri, files, Long.MIN_VALUE, Long.MAX_VALUE));
        } else {
            int i = 0;
            while (i < seriesStart.size()) {
                long seriesEnd = i + 1 < seriesStart.size() ? (Long)seriesStart.get(i + 1) : Long.MAX_VALUE;
                storage.series.add(new PersistentMRIDataSeries(mri, files, (Long)seriesStart.get(i), seriesEnd));
                ++i;
            }
        }
        this.storages.put(mri, storage);
    }

    private static File getPersistenceDirectoryPreference() {
        File persistenceDirectory = new File(RJMXPlugin.getDefault().getRJMXPreferences().get("rjmx.services.persistence.directory", PreferencesKeys.DEFAULT_PERSISTENCE_DIRECTORY));
        return persistenceDirectory;
    }

    public Set<MRI> getMRIs() {
        return this.storages.keySet();
    }

    public boolean isMRIAvailable(MRI mri) {
        return true;
    }

    public IAttributeStorage getAttributeStorage(MRI attributeDescriptor) {
        return this.storages.get(attributeDescriptor);
    }

    public int getRetainedLength(MRI attributeDescriptor) {
        return 0;
    }

    private static class FileIterator
    implements Iterator<ITimestampedData> {
        int nextIndex;
        ITimestampedData[] currentFileData;
        Iterator<PersistenceFile> files;
        long min;
        long max;
        ITimestampedData next;

        FileIterator(Iterator<PersistenceFile> data, long min, long max) {
            this.files = data;
            this.min = min;
            this.max = max;
            if (max > min) {
                this.binarySearchFirst();
            }
        }

        private void binarySearchFirst() {
            if (this.findNextFile()) {
                int highBound = this.currentFileData.length - 1;
                while (highBound >= this.nextIndex) {
                    int middleIndex = this.nextIndex + highBound >>> 1;
                    long middleX = (Long)this.currentFileData[middleIndex].getX();
                    if (middleX == this.min) {
                        this.nextIndex = middleIndex;
                        break;
                    }
                    if (middleX < this.min) {
                        this.nextIndex = middleIndex + 1;
                        continue;
                    }
                    highBound = middleIndex - 1;
                }
                this.readNext();
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public ITimestampedData next() {
            if (!this.hasNext()) {
                throw new IllegalStateException();
            }
            ITimestampedData tmp = this.next;
            if (this.currentFileData != null && this.nextIndex < this.currentFileData.length || this.findNextFile()) {
                this.readNext();
            } else {
                this.next = null;
            }
            return tmp;
        }

        private void readNext() {
            this.next = this.currentFileData[this.nextIndex++];
            this.next = (Long)this.next.getX() < this.max ? this.next : null;
        }

        private boolean findNextFile() {
            this.currentFileData = null;
            while (this.files.hasNext()) {
                PersistenceFile file = this.files.next();
                if (file.end < this.min) continue;
                if (file.start >= this.max) {
                    return false;
                }
                try {
                    this.currentFileData = file.getEvents(this.min, this.max);
                    if (this.currentFileData.length <= 0) continue;
                    this.nextIndex = 0;
                    return true;
                }
                catch (IOException e) {
                    RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not read events from file", e);
                }
            }
            return false;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class PersistenceStorage
    implements IAttributeStorage {
        List<PersistentMRIDataSeries> series = new ArrayList<PersistentMRIDataSeries>();

        private PersistenceStorage() {
        }

        public void addObserver(Observer o) {
        }

        public void deleteObserver(Observer o) {
        }

        public List<PersistentMRIDataSeries> getDataSeries() {
            return this.series;
        }

        public long getDataStart() {
            List<PersistenceFile> files;
            if (this.series.size() > 0 && (files = this.series.get((int)0).files).size() > 0) {
                return files.get((int)0).start;
            }
            return Long.MAX_VALUE;
        }

        public long getDataEnd() {
            List<PersistenceFile> files;
            if (this.series.size() > 0 && (files = this.series.get((int)(this.series.size() - 1)).files).size() > 0) {
                return files.get((int)(files.size() - 1)).end;
            }
            return Long.MIN_VALUE;
        }
    }

    private static class PersistentMRIDataSeries
    implements MRIDataSeries {
        List<PersistenceFile> files;
        MRI mri;
        long min;
        long max;

        PersistentMRIDataSeries(MRI mri, List<PersistenceFile> files, long min, long max) {
            this.files = files;
            this.mri = mri;
            this.min = min;
            this.max = max;
        }

        public Iterator<ITimestampedData> createIterator(long min, long max) {
            if (this.min <= max && this.max >= min) {
                return new FileIterator(this.files.iterator(), this.min, this.max);
            }
            return Collections.emptyList().iterator();
        }

        public MRI getAttribute() {
            return this.mri;
        }
    }
}

