/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.subscription.internal;

import java.util.logging.Level;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.openjdk.jmc.rjmx.RJMXPlugin;
import org.openjdk.jmc.rjmx.subscription.internal.AbstractSyntheticAttribute;

public class DeadlockedThreadCountAttribute
extends AbstractSyntheticAttribute {
    private static final int METHOD_INVOCATION_ERROR = -1;
    private static final int METHOD_NOT_PRESENT = -2;
    private boolean hasLoggedReflectionError = false;

    public Object getValue(MBeanServerConnection connection) {
        if (this.hasLoggedReflectionError) {
            return -2;
        }
        return this.getDeadlockedThreadCount(connection);
    }

    private int getDeadlockedThreadCount(MBeanServerConnection connection) {
        try {
            ObjectName threadMBean = new ObjectName("java.lang:type=Threading");
            Object result = connection.invoke(threadMBean, "findDeadlockedThreads", null, null);
            if (result != null && result instanceof long[]) {
                return ((long[])result).length;
            }
            return 0;
        }
        catch (ReflectionException e) {
            if (!this.hasLoggedReflectionError) {
                this.hasLoggedReflectionError = true;
                RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Unable to find findDeadlockedThreads(). Are you running a JVM version < 1.6?", e);
            }
            return -2;
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Unable to invoke findDeadlockedThreads(). Are you running a JVM version < 1.6?", e);
            return -1;
        }
    }

    public void setValue(MBeanServerConnection connection, Object value) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasResolvedDependencies(MBeanServerConnection connection) {
        try {
            ObjectName threadMBean = new ObjectName("java.lang:type=Threading");
            MBeanOperationInfo[] mBeanOperationInfoArray = connection.getMBeanInfo(threadMBean).getOperations();
            int n = mBeanOperationInfoArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                MBeanOperationInfo operation = mBeanOperationInfoArray[n2];
                if (operation.getName().equals("findDeadlockedThreads") && operation.getSignature().length == 0) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
        return false;
    }
}

