/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.subscription.internal;

import java.util.Properties;
import org.openjdk.jmc.rjmx.common.subscription.MRIValueEvent;
import org.openjdk.jmc.rjmx.subscription.internal.AbstractSingleMRITransformation;

public class DifferenceTransformation
extends AbstractSingleMRITransformation {
    private MRIValueEvent m_lastAttributeEvent;
    private long m_rateMS;

    @Override
    public void setProperties(Properties properties) {
        super.setProperties(properties);
        this.m_rateMS = Long.parseLong(properties.getProperty("rate", "0"));
    }

    public Object createSubscriptionValue(MRIValueEvent event) {
        Object lastValue = null;
        if (this.m_lastAttributeEvent != null) {
            lastValue = this.m_lastAttributeEvent.getValue();
        }
        Object value = event.getValue();
        Number eventValue = null;
        if (value instanceof Number && lastValue instanceof Number) {
            eventValue = this.subtract((Number)value, (Number)lastValue);
            if (this.m_rateMS > 0L) {
                eventValue = eventValue.doubleValue() * (double)this.m_rateMS / (double)(event.getTimestamp() - this.m_lastAttributeEvent.getTimestamp());
            }
        }
        this.m_lastAttributeEvent = event;
        return eventValue == null ? NO_VALUE : eventValue;
    }
}

