/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.browser.attach;

import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.management.remote.JMXServiceURL;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.openjdk.jmc.attach.AttachToolkit;
import org.openjdk.jmc.browser.attach.BrowserAttachPlugin;
import org.openjdk.jmc.browser.attach.LocalConnectionDescriptor;
import org.openjdk.jmc.browser.attach.internal.ExecuteTunnler;
import org.openjdk.jmc.browser.attach.internal.MonitoredHostWrapper;
import org.openjdk.jmc.browser.attach.internal.MonitoredVmWrapper;
import org.openjdk.jmc.common.jvm.Connectable;
import org.openjdk.jmc.common.jvm.JVMArch;
import org.openjdk.jmc.common.jvm.JVMDescriptor;
import org.openjdk.jmc.common.jvm.JVMType;
import org.openjdk.jmc.common.util.Environment;
import org.openjdk.jmc.common.version.JavaVMVersionToolkit;
import org.openjdk.jmc.rjmx.common.IConnectionDescriptor;
import org.openjdk.jmc.rjmx.common.IServerDescriptor;

public class LocalJVMToolkit {
    private static Class<?> CLASS_HOTSPOT_VIRTUAL_MACHINE;
    private static long SEQ_NUMBER;
    private static boolean isErrorMessageSent;
    private static boolean isPreferenceStoreListenerEnabled;
    private static boolean m_unconnectableInited;
    private static AtomicBoolean m_showUnconnectable;
    private static Map<Object, DiscoveryEntry> last;
    private static Thread sleeperThread;
    static final String LOCAL_CONNECTOR_ADDRESS_PROP = "com.sun.management.jmxremote.localConnectorAddress";
    static final String JVM_ARGS_PROP = "sun.jvm.args";
    static final String JVM_FLAGS_PROP = "sun.jvm.flags";
    static final String JAVA_COMMAND_PROP = "sun.java.command";
    private static final int TIMEOUT_THRESHOLD = 5;

    static {
        SEQ_NUMBER = 0L;
        isErrorMessageSent = false;
        m_unconnectableInited = false;
        m_showUnconnectable = new AtomicBoolean();
        last = new WeakHashMap<Object, DiscoveryEntry>();
        try {
            CLASS_HOTSPOT_VIRTUAL_MACHINE = Class.forName("sun.tools.attach.HotSpotVirtualMachine");
        }
        catch (ClassNotFoundException e) {
            CLASS_HOTSPOT_VIRTUAL_MACHINE = null;
            BrowserAttachPlugin.getPluginLogger().log(Level.WARNING, "Could not find attach related classes. This can affect discovery of locally running JVMs.", e);
        }
    }

    private LocalJVMToolkit() {
    }

    public static DiscoveryEntry[] getLocalConnections() {
        HashMap<Object, DiscoveryEntry> map = new HashMap<Object, DiscoveryEntry>();
        LocalJVMToolkit.populateAttachableVMs(map);
        LocalJVMToolkit.populateMonitoredVMs(map, LocalJVMToolkit.showUnconnectableJvms());
        last = map;
        ArrayList<DiscoveryEntry> list = new ArrayList<DiscoveryEntry>(map.values());
        return list.toArray(new DiscoveryEntry[list.size()]);
    }

    private static final boolean showUnconnectableJvms() {
        IPreferenceStore store;
        if (!m_unconnectableInited && (store = BrowserAttachPlugin.getDefault().getPreferenceStore()) != null) {
            m_showUnconnectable.set(store.getBoolean("showUnconnectable"));
            store.addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty().equals("showUnconnectable")) {
                        m_showUnconnectable.set((Boolean)event.getNewValue());
                    }
                }
            });
            m_unconnectableInited = true;
        }
        return m_showUnconnectable.get();
    }

    private static void populateMonitoredVMs(HashMap<Object, DiscoveryEntry> map, boolean includeUnconnectables) {
        MonitoredHostWrapper monitoredHost = MonitoredHostWrapper.getMonitoredHost();
        if (monitoredHost == null) {
            return;
        }
        Set<?> vms = monitoredHost.activeVms();
        for (Object vmid : vms) {
            if (!(vmid instanceof Integer) || map.containsKey(vmid)) continue;
            DiscoveryEntry connDesc = last.get(vmid);
            if (connDesc == null) {
                connDesc = LocalJVMToolkit.createMonitoredJvmDescriptor(monitoredHost, (Integer)vmid);
            }
            if ((!includeUnconnectables || connDesc == null) && (connDesc == null || connDesc.getServerDescriptor().getJvmInfo().isUnconnectable().booleanValue())) continue;
            map.put(vmid, connDesc);
        }
    }

    private static DiscoveryEntry createMonitoredJvmDescriptor(final MonitoredHostWrapper host, final Integer vmid) {
        try {
            ExecutorService service = Executors.newSingleThreadExecutor();
            Future<DiscoveryEntry> future = service.submit(new Callable<DiscoveryEntry>(){

                @Override
                public DiscoveryEntry call() throws Exception {
                    int pid = vmid;
                    String name = vmid.toString();
                    Connectable connectable = Connectable.NO;
                    JVMType type = JVMType.OTHER;
                    JVMArch jvmArch = JVMArch.OTHER;
                    boolean isDebug = false;
                    String address = null;
                    String version = null;
                    String jvmArgs = null;
                    String jvmName = null;
                    String jvmVendor = null;
                    try {
                        MonitoredVmWrapper mvm = host.getMonitoredVm(name);
                        try {
                            name = mvm.commandLine();
                            jvmArgs = mvm.jvmArgs();
                            jvmName = mvm.jvmName();
                            type = JVMType.getJVMType((String)jvmName);
                            version = mvm.javaVersion();
                            if (version == null) {
                                String vmVersion = mvm.jvmVersion();
                                version = type == JVMType.JROCKIT ? JavaVMVersionToolkit.decodeJavaVersion((String)vmVersion) : JavaVMVersionToolkit.parseJavaVersion((String)vmVersion);
                            }
                            if (version == null) {
                                version = "0";
                            }
                            isDebug = LocalJVMToolkit.isDebug(version);
                            jvmVendor = mvm.jvmVendor();
                            jvmArch = LocalJVMToolkit.getArch(vmid);
                            JMXServiceURL inMemURL = null;
                            try {
                                inMemURL = LocalJVMToolkit.getInMemoryURLFromPID(vmid);
                            }
                            catch (IOException e) {
                                BrowserAttachPlugin.getPluginLogger().log(Level.WARNING, "Got exception when trying to get in-memory url for jvm with PID " + String.valueOf(vmid), e);
                            }
                            if (inMemURL != null) {
                                connectable = Connectable.MGMNT_AGENT_STARTED;
                            }
                            address = AttachToolkit.importFromPid((Integer)pid);
                        }
                        finally {
                            mvm.detach();
                        }
                    }
                    catch (Exception exception) {}
                    DiscoveryEntry connDesc = LocalJVMToolkit.createDescriptor(name, jvmArgs, jvmName, jvmVendor, vmid, connectable, type, jvmArch, address, version, isDebug);
                    return connDesc;
                }
            });
            return future.get(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            BrowserAttachPlugin.getPluginLogger().log(Level.WARNING, "Failed to create descriptor for jvm with PID " + String.valueOf(vmid), e);
            return null;
        }
    }

    private static JVMArch getArch(Integer vmid) throws IOException {
        JVMArch jvmArch = JVMArch.OTHER;
        List<VirtualMachineDescriptor> vms = VirtualMachine.list();
        if (vms != null) {
            for (VirtualMachineDescriptor vmd : vms) {
                if (vmid != Integer.parseInt(vmd.id())) continue;
                try {
                    VirtualMachine vm = VirtualMachine.attach(vmd);
                    try {
                        jvmArch = JVMArch.getJVMArch((Properties)vm.getSystemProperties());
                    }
                    finally {
                        vm.detach();
                    }
                }
                catch (AttachNotSupportedException x) {
                    if (x.getMessage().contains("Unable to attach to 32-bit process")) {
                        jvmArch = JVMArch.BIT32;
                        break;
                    }
                    if (!x.getMessage().contains("Unable to attach to 64-bit process")) break;
                    jvmArch = JVMArch.BIT64;
                }
                break;
            }
        }
        return jvmArch;
    }

    private static boolean isDebug(String stringValue) {
        return stringValue.toUpperCase().contains("DEBUG");
    }

    private static void addPreferenceStoreListener() {
        if (!isPreferenceStoreListenerEnabled) {
            BrowserAttachPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty().equals("jvmAttachDelay") && sleeperThread.getState().equals((Object)Thread.State.TIMED_WAITING)) {
                        sleeperThread.interrupt();
                    }
                }
            });
            isPreferenceStoreListenerEnabled = true;
        }
    }

    private static final int getJvmAttachDelay() {
        return BrowserAttachPlugin.getDefault().getPreferenceStore().getInt("jvmAttachDelay");
    }

    private static void populateAttachableVMs(Map<Object, DiscoveryEntry> map) {
        List<VirtualMachineDescriptor> vms = VirtualMachine.list();
        if (vms == null) {
            return;
        }
        for (VirtualMachineDescriptor vmd : vms) {
            try {
                Integer vmid = Integer.valueOf(vmd.id());
                if (map.containsKey(vmid)) continue;
                BrowserAttachPlugin.getPluginLogger().finest("Local attach resolving PID " + String.valueOf(vmid));
                DiscoveryEntry connDesc = last.get(vmid);
                if (connDesc == null) {
                    if (LocalJVMToolkit.getJvmAttachDelay() > 0) {
                        LocalJVMToolkit.addPreferenceStoreListener();
                        sleeperThread = new Thread(() -> {
                            try {
                                Thread.sleep(LocalJVMToolkit.getJvmAttachDelay());
                            }
                            catch (InterruptedException interruptedException) {}
                        });
                        try {
                            sleeperThread.start();
                            sleeperThread.join();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    connDesc = LocalJVMToolkit.createAttachableJvmDescriptor(vmd);
                }
                if (connDesc == null || connDesc.getServerDescriptor().getJvmInfo().isUnconnectable().booleanValue()) continue;
                map.put(vmid, connDesc);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private static DiscoveryEntry createAttachableJvmDescriptor(final VirtualMachineDescriptor vmd) {
        try {
            ExecutorService service = Executors.newSingleThreadExecutor();
            Future<DiscoveryEntry> future = service.submit(new Callable<DiscoveryEntry>(){

                @Override
                public DiscoveryEntry call() throws Exception {
                    Connectable connectable;
                    String jvmVendor;
                    String jvmName;
                    String jvmArgs;
                    String javaArgs;
                    String version;
                    String address;
                    JVMArch jvmArch;
                    JVMType jvmType;
                    boolean isDebug;
                    DiscoveryEntry connDesc;
                    block16: {
                        connDesc = null;
                        isDebug = false;
                        jvmType = JVMType.OTHER;
                        jvmArch = JVMArch.OTHER;
                        address = null;
                        version = null;
                        javaArgs = null;
                        jvmArgs = null;
                        String jvmVersion = null;
                        jvmName = null;
                        jvmVendor = null;
                        VirtualMachine vm = null;
                        try {
                            try {
                                vm = VirtualMachine.attach(vmd);
                                connectable = Connectable.ATTACHABLE;
                                Properties props = null;
                                try {
                                    if (Integer.parseInt(vmd.id()) != Environment.getThisPID()) {
                                        try {
                                            if (CLASS_HOTSPOT_VIRTUAL_MACHINE != null) {
                                                Method methodStartLocalManagementAgent = CLASS_HOTSPOT_VIRTUAL_MACHINE.getMethod("startLocalManagementAgent", new Class[0]);
                                                methodStartLocalManagementAgent.invoke((Object)vm, new Object[0]);
                                            }
                                        }
                                        catch (Exception exception) {}
                                    }
                                    props = vm.getSystemProperties();
                                }
                                catch (IOException e) {
                                    BrowserAttachPlugin.getPluginLogger().log(Level.FINER, "Got the following exception message when getting system properties from vm with PID " + String.valueOf(vmd) + ": " + e.getMessage());
                                }
                                if (props != null) {
                                    jvmName = props.getProperty("java.vm.name");
                                    jvmType = JVMType.getJVMType((String)jvmName);
                                    version = props.getProperty("java.version");
                                    jvmVersion = props.getProperty("java.vm.version");
                                    jvmVendor = props.getProperty("java.vm.vendor");
                                    isDebug = LocalJVMToolkit.isDebug(jvmVersion);
                                    jvmArch = JVMArch.getJVMArch((Properties)props);
                                }
                                Properties agentProps = vm.getAgentProperties();
                                address = (String)agentProps.get(LocalJVMToolkit.LOCAL_CONNECTOR_ADDRESS_PROP);
                                javaArgs = LocalJVMToolkit.resolveCommandLine(vm, vmd.displayName(), props, agentProps);
                                jvmArgs = (String)agentProps.get(LocalJVMToolkit.JVM_ARGS_PROP);
                            }
                            catch (AttachNotSupportedException attachNotSupportedException) {
                                connectable = Connectable.NO;
                                if (vm != null) {
                                    vm.detach();
                                }
                                break block16;
                            }
                        }
                        catch (Throwable throwable) {
                            if (vm != null) {
                                vm.detach();
                            }
                            throw throwable;
                        }
                        if (vm != null) {
                            vm.detach();
                        }
                    }
                    if (connectable.isAttachable()) {
                        connDesc = LocalJVMToolkit.createDescriptor(javaArgs, jvmArgs, jvmName, jvmVendor, Integer.parseInt(vmd.id()), connectable, jvmType, jvmArch, address, version, isDebug);
                    }
                    BrowserAttachPlugin.getPluginLogger().info("Done resolving PID " + String.valueOf(vmd));
                    return connDesc;
                }
            });
            return future.get(5L, TimeUnit.SECONDS);
        }
        catch (Throwable t) {
            if (!isErrorMessageSent) {
                BrowserAttachPlugin.getPluginLogger().log(Level.FINER, "Scanning using attach/getAgentProperties failed on " + String.valueOf(vmd) + ". This message will only be printed once, so errors for subsequent PIDs will not be logged...", t);
                isErrorMessageSent = true;
            }
            return null;
        }
    }

    private static String resolveCommandLine(VirtualMachine vm, String displayName, Properties vmProps, Properties agentProps) {
        String eclipseVmargs;
        if (LocalJVMToolkit.isValidDisplayName(displayName)) {
            return displayName;
        }
        if (vmProps != null && (eclipseVmargs = vmProps.getProperty("eclipse.vmargs")) != null) {
            String[] parts = eclipseVmargs.split("java.class.path=");
            return parts.length == 2 ? parts[1] : eclipseVmargs;
        }
        if (agentProps != null) {
            String jvmCmd = (String)agentProps.get(JAVA_COMMAND_PROP);
            if (jvmCmd == null || jvmCmd.length() == 0) {
                jvmCmd = (String)agentProps.get(JVM_ARGS_PROP);
            }
            if (jvmCmd == null || jvmCmd.length() == 0) {
                jvmCmd = (String)agentProps.get(JVM_FLAGS_PROP);
            }
            if (jvmCmd != null && jvmCmd.length() > 0) {
                return jvmCmd;
            }
        }
        return displayName;
    }

    private static boolean isValidDisplayName(String displayName) {
        return displayName != null && !displayName.equals("") && !displayName.equals("Unknown");
    }

    private static DiscoveryEntry createDescriptor(String javaCommand, String jvmArgs, String jvmName, String jvmVendor, int pid, Connectable connectable, JVMType type, JVMArch arch, String address, String version, boolean isDebug) {
        JVMDescriptor jvmInfo = new JVMDescriptor(version, type, arch, javaCommand, jvmArgs, jvmName, jvmVendor, Integer.valueOf(pid), isDebug, connectable);
        LocalConnectionDescriptor lcd = new LocalConnectionDescriptor(pid, address, connectable == Connectable.ATTACHABLE);
        String guid = "Local-[PID:" + pid + ", seq:" + SEQ_NUMBER++ + "]";
        IServerDescriptor sd = IServerDescriptor.create((String)guid, null, (JVMDescriptor)jvmInfo);
        return new DiscoveryEntry(sd, lcd);
    }

    public static synchronized DiscoveryEntry[] getAttachableJVMs() {
        return LocalJVMToolkit.getLocalConnections();
    }

    public static String executeCommandForPid(String pid, String command) throws AttachNotSupportedException, IOException, AgentLoadException {
        return LocalJVMToolkit.executeCommandForPid(pid, command, false);
    }

    public static String executeCommandForPid(String pid, String command, boolean getCausingInformation) throws AttachNotSupportedException, IOException, AgentLoadException {
        VirtualMachine vm = VirtualMachine.attach(pid);
        String result = LocalJVMToolkit.executeCommandForPid(vm, pid, command, getCausingInformation);
        vm.detach();
        return result;
    }

    public static String executeCommandForPid(VirtualMachine vm, String pid, String command) throws AttachNotSupportedException, IOException, AgentLoadException {
        return LocalJVMToolkit.executeCommandForPid(vm, pid, command, false);
    }

    public static String executeCommandForPid(VirtualMachine vm, String pid, String command, boolean throwCausingException) throws AttachNotSupportedException, IOException, AgentLoadException {
        int n;
        InputStream in = ExecuteTunnler.execute(vm, "jcmd", new Object[]{command}, throwCausingException);
        byte[] b = new byte[256];
        StringBuffer buf = new StringBuffer();
        do {
            if ((n = in.read(b)) <= 0) continue;
            String s = new String(b, 0, n, StandardCharsets.UTF_8);
            buf.append(s);
        } while (n > 0);
        try {
            in.close();
        }
        catch (IOException iOException) {}
        return buf.toString();
    }

    public static JMXServiceURL getInMemoryURLFromPID(int pid) throws IOException {
        JMXServiceURL inMemURL = null;
        String address = AttachToolkit.importFromPid((Integer)pid);
        if (address != null) {
            inMemURL = new JMXServiceURL(address);
        }
        return inMemURL;
    }

    public static class DiscoveryEntry {
        private final IServerDescriptor serverDescriptor;
        private final IConnectionDescriptor connectionDescriptor;

        public DiscoveryEntry(IServerDescriptor serverDescriptor, IConnectionDescriptor descriptor) {
            this.serverDescriptor = serverDescriptor;
            this.connectionDescriptor = descriptor;
        }

        public IConnectionDescriptor getConnectionDescriptor() {
            return this.connectionDescriptor;
        }

        public IServerDescriptor getServerDescriptor() {
            return this.serverDescriptor;
        }
    }
}

