/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.tree;

import org.openjdk.jmc.common.unit.IQuantity;

public class Range {
    public final IQuantity startTime;
    public final IQuantity endTime;

    public Range(IQuantity startTime, IQuantity endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public boolean isInside(IQuantity time) {
        return this.startTime.compareTo((Object)time) <= 0 && this.endTime.compareTo((Object)time) >= 0;
    }

    public boolean isBefore(IQuantity time) {
        return this.startTime.compareTo((Object)time) > 0;
    }

    public boolean isAfter(IQuantity time) {
        return this.endTime.compareTo((Object)time) < 0;
    }

    public String toString() {
        return String.format("[%s, %s]", this.startTime.displayUsing("auto"), this.endTime.displayUsing("auto"));
    }
}

