/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.greychart.ui.views.legend;

import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.greychart.ui.views.legend.IPositionProvider;
import org.openjdk.jmc.ui.accessibility.AccessibilityConstants;
import org.openjdk.jmc.ui.accessibility.FocusTracker;
import org.openjdk.jmc.ui.accessibility.MCAccessibleListener;

public class LegendViewer
extends ContentViewer {
    protected final FormToolkit m_formToolkit;
    private final Composite m_container;

    public LegendViewer(Composite parent, FormToolkit formToolkit) {
        this.m_formToolkit = formToolkit;
        this.m_container = formToolkit.createComposite(parent);
        this.hookControl((Control)this.m_container);
        this.m_container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LegendViewer.this.dispose();
            }
        });
        this.adaptForAccessibility(this.m_container, "Legend");
    }

    public void dispose() {
        IBaseLabelProvider l = this.getLabelProvider();
        if (l != null) {
            l.dispose();
        }
    }

    private void adaptForAccessibility(Composite control, String name) {
        FocusTracker.enableFocusTracking((Composite)control);
        MCAccessibleListener accessibleListener = new MCAccessibleListener();
        accessibleListener.setComponentType(AccessibilityConstants.COMPONENT_TYPE_LEGEND);
        accessibleListener.setName(name);
        control.getAccessible().addAccessibleListener((AccessibleListener)accessibleListener);
    }

    public void inputChanged(Object input, Object oldInput) {
        this.refresh();
    }

    public void refresh() {
        this.ensureValid();
        this.destroy();
        if (this.hasElementsPositions()) {
            this.m_container.setLayout(this.createMarginFreeLayout(3));
            this.createMultiAxisLegend(this.m_container);
        } else {
            this.m_container.setLayout(this.createMarginFreeLayout(1));
            this.createAxisLegend(this.m_container, 0);
        }
        this.m_container.layout(true, true);
    }

    private GridLayout createAxisLegendLayout(int itemCount) {
        boolean isMultiRow = itemCount > 5;
        int columnCount = isMultiRow ? 3 : itemCount;
        GridLayout layout = new GridLayout(columnCount, false);
        layout.marginHeight = 1;
        layout.marginWidth = 2;
        layout.verticalSpacing = isMultiRow ? 5 : 0;
        return layout;
    }

    private void createMultiAxisLegend(Composite container) {
        GridData gd1 = new GridData(1, 1, false, false);
        Composite left = this.createAxisLegend(container, 16384);
        left.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false);
        Label l = this.m_formToolkit.createLabel(container, " ");
        l.setLayoutData((Object)gd2);
        GridData gd3 = new GridData(0x1000008, 1, false, false);
        Composite right = this.createAxisLegend(container, 131072);
        right.setLayoutData((Object)gd3);
    }

    private Composite createAxisLegend(Composite parent, int position) {
        Composite container = this.m_formToolkit.createComposite(parent);
        int itemCount = 0;
        Object[] objectArray = this.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (this.getPosition(element) == position) {
                GridData gd = new GridData(4, 4, false, false);
                Control item = this.createControl(container, element);
                item.setLayoutData((Object)gd);
                ++itemCount;
            }
            ++n2;
        }
        container.setLayout((Layout)this.createAxisLegendLayout(itemCount));
        return container;
    }

    private Object[] getElements() {
        return this.getStructuredContentProvider().getElements(this.getInput());
    }

    private boolean hasElementsPositions() {
        return this.getLabelProvider() instanceof IPositionProvider;
    }

    private Layout createMarginFreeLayout(int columnCount) {
        GridLayout layout = new GridLayout(columnCount, false);
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginWidth = 2;
        layout.marginHeight = 1;
        return layout;
    }

    protected Control createControl(Composite parent, Object element) {
        Image image = this.getImage(element);
        String text = this.getText(element);
        FormText formText = this.m_formToolkit.createFormText(parent, false);
        formText.setImage("colorKey", image);
        formText.setImage("backgroundimage", this.createBackgroundImage(this.m_formToolkit, (Composite)formText, image.getBounds().height));
        formText.setText("<form><p>" + LegendViewer.formatHTMLImageDescription("colorKey", text) + "</p></form>", true, false);
        formText.setData("name", (Object)text);
        return formText;
    }

    private int getPosition(Object element) {
        if (this.hasElementsPositions()) {
            return ((IPositionProvider)this.getLabelProvider()).getPosition(element);
        }
        return 0;
    }

    protected Image getImage(Object element) {
        return ((ILabelProvider)this.getLabelProvider()).getImage(element);
    }

    protected String getText(Object element) {
        return ((ILabelProvider)this.getLabelProvider()).getText(element);
    }

    private IStructuredContentProvider getStructuredContentProvider() {
        return (IStructuredContentProvider)this.getContentProvider();
    }

    private void ensureValid() {
        if (!(this.getContentProvider() instanceof IStructuredContentProvider)) {
            throw new IllegalStateException("Must have an IStructuredContentProvider.");
        }
        if (!(this.getLabelProvider() instanceof ILabelProvider)) {
            throw new IllegalStateException("Missing ILabelProvider.");
        }
    }

    private void destroy() {
        Control[] controls;
        Control[] controlArray = controls = this.m_container.getChildren();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
    }

    private static String formatHTMLImageDescription(String imageKey, String name) {
        String html = "<img align='middle'  href='" + imageKey + "'/>";
        html = html + "<img href='backgroundimage'/>";
        html = html + name;
        return html;
    }

    public Control getControl() {
        return this.m_container;
    }

    public ISelection getSelection() {
        throw new UnsupportedOperationException("Unsupported");
    }

    public void setSelection(ISelection selection, boolean reveal) {
        throw new UnsupportedOperationException("Unsupported");
    }

    private Image createBackgroundImage(FormToolkit toolkit, Composite parent, int size) {
        final Image image = new Image((Device)parent.getDisplay(), 5, size);
        GC gc = new GC((Drawable)image);
        gc.setBackground(toolkit.getColors().getBackground());
        gc.fillRectangle(image.getBounds());
        gc.dispose();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (image != null) {
                    image.dispose();
                }
            }
        });
        return image;
    }
}

