/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rcp.application.scripting.model;

import java.text.ParseException;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.openjdk.jmc.commands.CommandsPlugin;
import org.openjdk.jmc.rcp.application.scripting.model.Process;
import org.openjdk.jmc.ui.misc.DisplayToolkit;

public final class OperatingSystem {
    private static final int TIME_SLICE = 100;
    private final Process m_process;
    private final Display m_display;

    public OperatingSystem(Display display, Process process) {
        this.m_process = process;
        this.m_display = display;
    }

    public void scheduleProcess() {
        DisplayToolkit.safeTimerExec((Display)this.m_display, (int)100, (Runnable)new Runnable(){

            @Override
            public void run() {
                OperatingSystem.this.tryToExecute();
            }
        });
    }

    public boolean execute(Process p) {
        if (p.getProgram().getLineCount() > 0) {
            try {
                CommandsPlugin.getDefault().execute(p.getInstruction().getSource(), p.getStandardOut());
            }
            catch (ParseException e) {
                p.getErrorOut().println(e.getMessage());
                p.stop();
                return false;
            }
            p.nextInstruction();
            if (!p.hasMoreinstuctions()) {
                p.terminate();
            }
            return true;
        }
        return false;
    }

    public Process getProcessInFocus() {
        return this.m_process;
    }

    void tryToExecute() {
        if (this.m_process.isRunning()) {
            IJobManager manager = Job.getJobManager();
            if (manager.isIdle()) {
                this.execute(this.m_process);
                if (this.m_process.isSingleStep()) {
                    return;
                }
            }
            this.scheduleProcess();
        }
    }
}

