/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client.request;

import java.util.Date;
import org.jolokia.client.request.J4pRequest;
import org.jolokia.client.request.J4pType;
import org.json.simple.JSONObject;

public abstract class J4pResponse<T extends J4pRequest> {
    private final JSONObject jsonResponse;
    private final T request;
    private final Date requestDate;

    protected J4pResponse(T pRequest, JSONObject pJsonResponse) {
        this.request = pRequest;
        this.jsonResponse = pJsonResponse;
        Long timestamp = (Long)this.jsonResponse.get("timestamp");
        this.requestDate = timestamp != null ? new Date(timestamp * 1000L) : new Date();
    }

    public T getRequest() {
        return this.request;
    }

    public J4pType getType() {
        return ((J4pRequest)this.request).getType();
    }

    public Date getRequestDate() {
        return (Date)this.requestDate.clone();
    }

    public <V> V getValue() {
        return this.jsonResponse.get("value");
    }

    public JSONObject asJSONObject() {
        return this.jsonResponse;
    }
}

