/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.tabs.threads;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.console.ui.tabs.threads.IThreadsModel;
import org.openjdk.jmc.console.ui.tabs.threads.StackTraceSectionPart;
import org.openjdk.jmc.console.ui.tabs.threads.ThreadTableSectionPart;
import org.openjdk.jmc.ui.OrientationAction;
import org.openjdk.jmc.ui.polling.PollManager;

public class ThreadMasterDetailBlock {
    private static final String VERTICAL_SASH_ID = "verticalSash";
    private final ThreadTableSectionPart threadTableSectionPart;
    private final SashForm sashForm;

    public ThreadMasterDetailBlock(Composite parent, IManagedForm managedForm, IWorkbenchPartSite site, IThreadsModel model, IMemento state) {
        FormToolkit toolkit = managedForm.getToolkit();
        boolean vertical = state == null ? true : !Boolean.FALSE.equals(state.getBoolean(VERTICAL_SASH_ID));
        this.sashForm = new SashForm(parent, vertical ? 512 : 256);
        toolkit.adapt((Control)this.sashForm, false, false);
        this.threadTableSectionPart = new ThreadTableSectionPart((Composite)this.sashForm, toolkit, model, state);
        managedForm.addPart((IFormPart)this.threadTableSectionPart);
        model.getPollManager().addPollee((PollManager.Pollable)this.threadTableSectionPart);
        StackTraceSectionPart stackTracePart = new StackTraceSectionPart((Composite)this.sashForm, managedForm, site, model);
        managedForm.addPart((IFormPart)stackTracePart);
        model.getPollManager().addPollee((PollManager.Pollable)stackTracePart);
        this.threadTableSectionPart.addSelectionListener(stackTracePart);
        this.sashForm.setWeights(new int[]{2, 1});
        OrientationAction.installActions((IManagedForm)managedForm, (SashForm)this.sashForm);
    }

    SashForm getSashForm() {
        return this.sashForm;
    }

    void saveState(IMemento memento) {
        memento.putBoolean(VERTICAL_SASH_ID, this.sashForm.getOrientation() == 512);
        this.threadTableSectionPart.saveState(memento);
    }
}

