/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemQuery;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.item.ItemQueryBuilder;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class DMSIncidentRule
implements IRule {
    private static final String RESULT_ID = "DMSIncident";
    private static final String DMS_PATH = "http://www.oracle.com/dms/dfw/dms/dfw/DFW_Incident/DFW_Incident_state";
    private static final IItemFilter FILTER = ItemFilters.type((String)"http://www.oracle.com/dms/dfw/dms/dfw/DFW_Incident/DFW_Incident_state");
    public static final IAggregator<IQuantity, ?> INCIDENTS_COUNT = Aggregators.count((String)Messages.getString("DMSIncidentRule_AGGR_INCIDENTS_COUNT"), (String)Messages.getString("DMSIncidentRule_AGGR_INCIDENTS_COUNT_DESC"), (IItemFilter)FILTER);
    private static final TypedPreference<IQuantity> WARNING_LIMIT = new TypedPreference("dmsincident.warning.limit", Messages.getString("DMSIncidentRule_CONFIG_WARNING_LIMIT"), Messages.getString("DMSIncidentRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(1L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(WARNING_LIMIT);
    public static final TypedResult<IQuantity> DMS_INCIDENTS = new TypedResult("dmsIncidentCount", INCIDENTS_COUNT, (ContentType)UnitLookup.NUMBER, IQuantity.class);
    private static final List<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, DMS_INCIDENTS);
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("http://www.oracle.com/dms/dfw/dms/dfw/DFW_Incident/DFW_Incident_state", RulesToolkit.EventAvailability.ENABLED).build();

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        IQuantity limit = (IQuantity)valueProvider.getPreferenceValue(WARNING_LIMIT);
        IQuantity incidents = (IQuantity)items.getAggregate(INCIDENTS_COUNT);
        if (incidents != null && incidents.compareTo((Object)limit) >= 0) {
            double score = RulesToolkit.mapExp100((double)incidents.doubleValue(), (double)limit.doubleValueIn(incidents.getUnit()));
            IItemQuery query = ItemQueryBuilder.fromWhere((IItemFilter)FILTER).build();
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.get((double)score)).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).addResult(DMS_INCIDENTS, (Object)incidents).addResult(TypedResult.ITEM_QUERY, (Object)query).setSummary(Messages.getString("DMSIncidentRuleFactory_TEXT_WARN")).setExplanation(Messages.getString("DMSIncidentRuleFactory_TEXT_WARN_LONG")).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSolution(Messages.getString("DMSIncidentRuleFactory_TEXT_OK")).build();
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return DMSIncidentRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("DMSIncidentRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "DMS";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

