/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class VerifyNoneRule
implements IRule {
    private static final String VERIFYNONE_RESULT_ID = "BytecodeVerification";
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.JVMInformation", RulesToolkit.EventAvailability.AVAILABLE).build();

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        String noVerify;
        String verifyNone = RulesToolkit.findMatches((String)"jdk.JVMInformation", (IItemCollection)items, (IAttribute)JdkAttributes.JVM_ARGUMENTS, (String)"\\-Xverify:none", (boolean)false);
        if (verifyNone == null) {
            verifyNone = RulesToolkit.findMatches((String)"jdk.JVMInformation", (IItemCollection)items, (IAttribute)JdkAttributes.JAVA_ARGUMENTS, (String)"\\-Xverify:none", (boolean)false);
        }
        if ((noVerify = RulesToolkit.findMatches((String)"jdk.JVMInformation", (IItemCollection)items, (IAttribute)JdkAttributes.JVM_ARGUMENTS, (String)"\\-noverify*", (boolean)false)) == null) {
            noVerify = RulesToolkit.findMatches((String)"jdk.JVMInformation", (IItemCollection)items, (IAttribute)JdkAttributes.JAVA_ARGUMENTS, (String)"\\-noverify*", (boolean)false);
        }
        if (verifyNone != null || noVerify != null) {
            String wls = RulesToolkit.findMatches((String)"jdk.JVMInformation", (IItemCollection)items, (IAttribute)JdkAttributes.JAVA_ARGUMENTS, (String)"weblogic.Server", (boolean)false);
            if (wls != null) {
                return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("VerifyNoneRule_WLS_TEXT_INFO")).setExplanation(Messages.getString("VerifyNoneRule_WLS_TEXT_INFO_LONG")).build();
            }
            String argument = verifyNone != null ? verifyNone : noVerify;
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.WARNING).setSummary(Messages.getString("VerifyNoneRule_TEXT_INFO")).setExplanation(MessageFormat.format(Messages.getString("VerifyNoneRule_TEXT_INFO_LONG"), argument)).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("VerifyNoneRule_TEXT_OK")).build();
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return VerifyNoneRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return VERIFYNONE_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("VerifyNoneRule_RULE_NAME");
    }

    public String getTopic() {
        return "jvm_information";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return Collections.emptyList();
    }
}

