/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.memory.GarbageCollectionsInfo;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class GarbageCollectionInfoRule
implements IRule {
    private static final String GARBAGE_COLLECTION_RESULT_ID = "GarbageCollectionInfoRule";
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.GarbageCollection", RulesToolkit.EventAvailability.AVAILABLE).build();
    private static final ContentType<GarbageCollectionsInfo> GC_INFO_TYPE = UnitLookup.createSyntheticContentType((String)"gcInfoType");
    public static final TypedResult<GarbageCollectionsInfo> GC_INFO = new TypedResult("gcInfo", GarbageCollectionsInfo.GC_INFO_AGGREGATOR, GC_INFO_TYPE, GarbageCollectionsInfo.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(GC_INFO);

    public String getId() {
        return GARBAGE_COLLECTION_RESULT_ID;
    }

    public String getTopic() {
        return "garbage_collection";
    }

    public String getName() {
        return Messages.getString("GarbageCollectionInfo_RULE_NAME");
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider preferenceValueProvider, IResultValueProvider dependencyResults) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                GarbageCollectionsInfo aggregate = (GarbageCollectionsInfo)items.getAggregate(GarbageCollectionsInfo.GC_INFO_AGGREGATOR);
                if (aggregate.foundNonRequestedSerialOldGc() || aggregate.getGcCount() > 0 || aggregate.getGcLockers() > 0 || aggregate.getObjectCountGCs() > 0 || aggregate.getSystemGcCount() > 0) {
                    return ResultBuilder.createFor((IRule)GarbageCollectionInfoRule.this, (IPreferenceValueProvider)preferenceValueProvider).setSeverity(Severity.OK).addResult(GC_INFO, (Object)aggregate).build();
                }
                return ResultBuilder.createFor((IRule)GarbageCollectionInfoRule.this, (IPreferenceValueProvider)preferenceValueProvider).setSeverity(Severity.NA).build();
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

