/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.ui.swt;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.openjdk.jmc.joverflow.ui.swt.PieChart;

public class ArcItem
extends Item {
    private final PieChart mParent;
    private final int mStyle;
    private int mAngle = 0;
    private Color mColor;

    public ArcItem(PieChart parent, int style) {
        this(parent, style, parent.getItemCount());
    }

    public ArcItem(PieChart parent, int style, int index) {
        super((Widget)parent, style, index);
        this.mParent = parent;
        this.mStyle = style;
        parent.createItem(this, index);
    }

    public void setAngle(int angle) {
        if (angle < 0) {
            SWT.error((int)6);
            return;
        }
        this.mAngle = angle > 360 ? angle % 360 : angle;
        this.mParent.redraw();
    }

    public int getAngle() {
        return this.mAngle;
    }

    public void setColor(Color mColor) {
        this.mColor = mColor;
        this.mParent.redraw();
    }

    public Color getColor() {
        return this.mColor;
    }

    void paintArc(GC gc, Point center, int radius, int startAngle, double zoomRatio, boolean paintArcBorder) {
        if (this.mAngle < 0) {
            SWT.error((int)6);
        }
        if (this.mColor != null) {
            gc.setBackground(this.mColor);
        }
        int outerRadius = (int)((double)radius * zoomRatio);
        gc.fillArc(center.x - outerRadius, center.y - outerRadius, outerRadius * 2, outerRadius * 2, startAngle, this.mAngle);
        if (paintArcBorder) {
            gc.drawArc(center.x - outerRadius, center.y - outerRadius, outerRadius * 2, outerRadius * 2, startAngle, this.mAngle);
            if (zoomRatio != 1.0 && this.mAngle < 360) {
                gc.drawLine((int)((double)center.x + Math.cos(Math.toRadians(startAngle)) * (double)radius), (int)((double)center.y - Math.sin(Math.toRadians(startAngle)) * (double)radius), (int)((double)center.x + Math.cos(Math.toRadians(startAngle)) * (double)outerRadius), (int)((double)center.y - Math.sin(Math.toRadians(startAngle)) * (double)outerRadius));
                gc.drawLine((int)((double)center.x + Math.cos(Math.toRadians(startAngle + this.mAngle)) * (double)radius), (int)((double)center.y - Math.sin(Math.toRadians(startAngle + this.mAngle)) * (double)radius), (int)((double)center.x + Math.cos(Math.toRadians(startAngle + this.mAngle)) * (double)outerRadius), (int)((double)center.y - Math.sin(Math.toRadians(startAngle + this.mAngle)) * (double)outerRadius));
            }
        }
        if ((this.mStyle & 0x800) == 2048 && this.mAngle < 360) {
            gc.drawLine(center.x, center.y, (int)((double)center.x + Math.cos(Math.toRadians(startAngle)) * (double)radius), (int)((double)center.y - Math.sin(Math.toRadians(startAngle)) * (double)radius));
            gc.drawLine(center.x, center.y, (int)((double)center.x + Math.cos(Math.toRadians(startAngle + this.mAngle)) * (double)radius), (int)((double)center.y - Math.sin(Math.toRadians(startAngle + this.mAngle)) * (double)radius));
        }
    }
}

