/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.overview;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.ui.DataPageDescriptor;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.overview.ResultOverview;
import org.openjdk.jmc.ui.column.ColumnBuilder;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.ColumnsFilter;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.MCLayoutFactory;
import org.openjdk.jmc.ui.misc.TypedLabelProvider;

class ResultTableUi {
    static final String TABLE_PREF_ROOT = "table";
    private final ColumnManager columnsManager;
    private Map<IResult, DataPageDescriptor> resultMap;
    private final IPageContainer editor;
    private TableViewer viewer;
    private IDoubleClickListener listener;

    public ResultTableUi(Form parent, FormToolkit toolkit, IPageContainer editor, IState state, Map<IResult, DataPageDescriptor> resultMap) {
        this.editor = editor;
        this.resultMap = resultMap;
        Composite resultTableComposite = toolkit.createComposite(parent.getBody());
        resultTableComposite.setLayout(MCLayoutFactory.createMarginFreeFormPageLayout());
        Composite filterComposite = toolkit.createComposite(resultTableComposite);
        filterComposite.setLayoutData(MCLayoutFactory.createFormPageLayoutData((int)-1, (int)-1, (boolean)true, (boolean)false));
        Table table = toolkit.createTable(resultTableComposite, 268501762);
        table.setLayoutData(MCLayoutFactory.createFormPageLayoutData());
        this.viewer = new TableViewer(table);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        this.columnsManager = ColumnManager.build((TableViewer)this.viewer, this.createColumns(), (TableSettings)TableSettings.forState((IState)state.getChild(TABLE_PREF_ROOT)));
        ColumnMenusFactory.addDefaultMenus((ColumnManager)this.columnsManager, (MCContextMenuManager)MCContextMenuManager.create((Control)table));
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setInput((Object)resultMap.keySet().toArray());
        this.listener = this.navigateListener(editor, resultMap);
        this.viewer.addDoubleClickListener(this.listener);
        filterComposite.setLayout((Layout)new GridLayout(2, false));
        ColumnsFilter.addFilterControl((Composite)filterComposite, (FormToolkit)toolkit, (ColumnManager)this.columnsManager);
    }

    private IDoubleClickListener navigateListener(IPageContainer editor, Map<IResult, DataPageDescriptor> resultMap) {
        return event -> {
            DataPageDescriptor page;
            StructuredSelection selection;
            if (event.getSelection() instanceof StructuredSelection && !(selection = (StructuredSelection)event.getSelection()).isEmpty() && selection.getFirstElement() instanceof IResult && (page = (DataPageDescriptor)resultMap.get(selection.getFirstElement())) != null) {
                editor.navigateTo(page);
            }
        };
    }

    void updateInput(Map<IResult, DataPageDescriptor> resultMap) {
        this.resultMap = resultMap;
        this.viewer.setInput((Object)resultMap.keySet().toArray());
        this.updateListener();
    }

    private void updateListener() {
        this.viewer.removeDoubleClickListener(this.listener);
        this.listener = this.navigateListener(this.editor, this.resultMap);
        this.viewer.addDoubleClickListener(this.listener);
    }

    private List<IColumn> createColumns() {
        IColumn scoreColumn = new ColumnBuilder(Messages.ResultOverview_COLUMN_SCORE, "score", (ColumnLabelProvider)new ScoreLabelProvider(IResult.class)).comparator((Comparator)new ScoreComparator()).build();
        IColumn nameColumn = new ColumnBuilder(Messages.ResultOverview_COLUMN_RULE_NAME, "name", (ColumnLabelProvider)new TypedLabelProvider<IResult>(IResult.class){

            public String getTextTyped(IResult IResult2) {
                return IResult2.getRule().getName();
            }
        }).build();
        IColumn summaryColumn = new ColumnBuilder(Messages.ResultOverview_COLUMN_SUMMARY, "summary", (ColumnLabelProvider)new TypedLabelProvider<IResult>(IResult.class){

            public String getTextTyped(IResult IResult2) {
                return IResult2.getSummary();
            }
        }).build();
        IColumn explanationColumn = new ColumnBuilder(Messages.ResultOverview_COLUMN_EXPLANATION, "explanation", (ColumnLabelProvider)new TypedLabelProvider<IResult>(IResult.class){

            public String getTextTyped(IResult IResult2) {
                return IResult2.getExplanation();
            }
        }).build();
        IColumn solutionColumn = new ColumnBuilder(Messages.ResultOverview_COLUMN_SOLUTION, "solution", (ColumnLabelProvider)new TypedLabelProvider<IResult>(IResult.class){

            public String getTextTyped(IResult IResult2) {
                return IResult2.getSolution();
            }
        }).build();
        IColumn idColumn = new ColumnBuilder(Messages.ResultOverview_COLUMN_RESULT_ID, "id", (ColumnLabelProvider)new TypedLabelProvider<IResult>(IResult.class){

            public String getTextTyped(IResult IResult2) {
                return IResult2.getRule().getId();
            }
        }).build();
        IColumn pageColumn = new ColumnBuilder(Messages.ResultOverview_COLUMN_PAGE, "page", (ColumnLabelProvider)new TypedLabelProvider<IResult>(IResult.class){

            public String getTextTyped(IResult IResult2) {
                DataPageDescriptor page = ResultTableUi.this.resultMap.get(IResult2);
                if (page == null) {
                    return null;
                }
                return ResultTableUi.this.editor.getDisplayablePage(page).getName();
            }
        }).comparator((Comparator)new PageComparator()).build();
        return Arrays.asList(scoreColumn, nameColumn, summaryColumn, explanationColumn, solutionColumn, idColumn, pageColumn);
    }

    public void saveTo(IWritableState state) {
        this.columnsManager.getSettings().saveState(state.createChild(TABLE_PREF_ROOT));
    }

    private class PageComparator
    implements Comparator<Object> {
        private PageComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof IResult && o2 instanceof IResult) {
                DataPageDescriptor p1 = ResultTableUi.this.resultMap.get(o1);
                DataPageDescriptor p2 = ResultTableUi.this.resultMap.get(o2);
                if (p1 != null && p2 != null) {
                    return ResultTableUi.this.editor.getDisplayablePage(p1).getName().compareTo(ResultTableUi.this.editor.getDisplayablePage(p2).getName());
                }
            }
            return 0;
        }
    }

    private static class ScoreComparator
    implements Comparator<Object> {
        private ScoreComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof IResult && o2 instanceof IResult) {
                IResult r1 = (IResult)o1;
                IResult r2 = (IResult)o2;
                IQuantity score1 = (IQuantity)r1.getResult(TypedResult.SCORE);
                IQuantity score2 = (IQuantity)r2.getResult(TypedResult.SCORE);
                double s1 = score1 == null ? r1.getSeverity().getLimit() : score1.doubleValue();
                double s2 = score2 == null ? r2.getSeverity().getLimit() : score2.doubleValue();
                return Double.compare(s1, s2);
            }
            return 0;
        }
    }

    private static class ScoreLabelProvider
    extends TypedLabelProvider<IResult> {
        private final Map<ImageDescriptor, Image> images = new HashMap<ImageDescriptor, Image>();

        private ScoreLabelProvider(Class<IResult> elementClass) {
            super(elementClass);
        }

        private Image image(ImageDescriptor descr) {
            Image image = this.images.get(descr);
            if (image != null) {
                return image;
            }
            image = descr.createImage();
            this.images.put(descr, image);
            return image;
        }

        protected Image getImageTyped(IResult IResult2) {
            switch (IResult2.getSeverity()) {
                case WARNING: {
                    return this.image(ResultOverview.ICON_WARNING);
                }
                case INFO: {
                    return this.image(ResultOverview.ICON_INFO);
                }
                case OK: {
                    return this.image(ResultOverview.ICON_OK);
                }
                case IGNORE: {
                    return this.image(ResultOverview.ICON_IGNORE);
                }
                case NA: {
                    return this.image(ResultOverview.ICON_NA);
                }
            }
            return null;
        }

        public String getTextTyped(IResult IResult2) {
            return IResult2.getSeverity().getLocalizedName();
        }

        protected String getToolTipTextTyped(IResult IResult2) {
            return MessageFormat.format(Messages.ResultTableUi_SCORE_TOOLTIP, IResult2.getSeverity());
        }

        public void dispose() {
            super.dispose();
            for (Image image : this.images.values()) {
                image.dispose();
            }
            this.images.clear();
        }
    }
}

