/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages;

import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDataPageFactory;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageDefinition;
import org.openjdk.jmc.flightrecorder.ui.IPageUI;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.AbstractDataPage;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.FilterComponent;
import org.openjdk.jmc.flightrecorder.ui.common.FlavorSelector;
import org.openjdk.jmc.flightrecorder.ui.common.ItemHistogram;
import org.openjdk.jmc.flightrecorder.ui.common.ItemHistogramWithInput;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.selection.SelectionStoreActionToolkit;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.PersistableSashForm;

public class LockInstancesPage
extends AbstractDataPage {
    private static final IAggregator<IQuantity, ?> BY_THREAD_AGGREGATOR = Aggregators.filter((IAggregator)Aggregators.countDistinct((String)Messages.LockInstancesPage_AGGR_BY_THREAD, (String)Messages.LockInstancesPage_AGGR_BY_THREAD_DESC, (IAccessorFactory)JfrAttributes.EVENT_THREAD), (IItemFilter)JdkFilters.MONITOR_ENTER);
    private static final IAggregator<IQuantity, ?> BY_ADDRESS_AGGREGATOR = Aggregators.filter((IAggregator)Aggregators.countDistinct((String)Messages.LockInstancesPage_AGGR_BY_ADDRESS, (String)Messages.LockInstancesPage_AGGR_BY_ADDRESS_DESC, (IAccessorFactory)JdkAttributes.MONITOR_ADDRESS), (IItemFilter)JdkFilters.MONITOR_ENTER);
    private static final IItemFilter TABLE_ITEMS = ItemFilters.or((IItemFilter[])new IItemFilter[]{JdkFilters.MONITOR_ENTER, JdkFilters.MONITOR_INFLATE});
    private static final ItemHistogram.ItemHistogramBuilder BY_CLASS_HISTOGRAM = new ItemHistogram.ItemHistogramBuilder();
    private static final ItemHistogram.ItemHistogramBuilder BY_ADDRESS_HISTOGRAM = new ItemHistogram.ItemHistogramBuilder();
    private static final ItemHistogram.ItemHistogramBuilder BY_THREAD_HISTOGRAM = new ItemHistogram.ItemHistogramBuilder();
    private static final String STD_DEV_DURATION = "stdDevDuration";
    private static final String AVG_DURATION = "avgDuration";
    private static final String MAX_DURATION = "maxDuration";
    private static final String INFLATED_COUNT = "countInflated";
    private static final String INFLATED_CAUSE = "causeOfInflation";
    private IItemFilter byAddressFilter;
    private ColumnManager.SelectionState byAddressState;
    private IItemFilter byThreadFilter;
    private ColumnManager.SelectionState byThreadState;
    private IItemFilter byClassFilter;
    private ColumnManager.SelectionState byClassState;
    public FlavorSelector.FlavorSelectorState flavorSelectorState;

    static {
        BY_CLASS_HISTOGRAM.addCountColumn();
        BY_CLASS_HISTOGRAM.addColumn(JfrAttributes.DURATION.getIdentifier(), JdkAggregators.TOTAL_BLOCKED_TIME);
        BY_CLASS_HISTOGRAM.addColumn(MAX_DURATION, JdkAggregators.MAX_BLOCKED_TIME);
        BY_CLASS_HISTOGRAM.addColumn(AVG_DURATION, JdkAggregators.AVG_BLOCKED_TIME);
        BY_CLASS_HISTOGRAM.addColumn(STD_DEV_DURATION, JdkAggregators.STDDEV_BLOCKED_TIME);
        BY_CLASS_HISTOGRAM.addColumn(JdkAttributes.MONITOR_CLASS.getIdentifier(), BY_ADDRESS_AGGREGATOR);
        BY_CLASS_HISTOGRAM.addColumn(JfrAttributes.EVENT_THREAD.getIdentifier(), BY_THREAD_AGGREGATOR);
        BY_CLASS_HISTOGRAM.addColumn(INFLATED_COUNT, JdkAggregators.TOTAL_INFLATED_COUNT);
        BY_CLASS_HISTOGRAM.addColumn(INFLATED_CAUSE, JdkAggregators.MONITOR_INFLATE_REASON);
        BY_ADDRESS_HISTOGRAM.addCountColumn();
        BY_ADDRESS_HISTOGRAM.addColumn(JfrAttributes.DURATION.getIdentifier(), JdkAggregators.TOTAL_BLOCKED_TIME);
        BY_ADDRESS_HISTOGRAM.addColumn(MAX_DURATION, JdkAggregators.MAX_BLOCKED_TIME);
        BY_ADDRESS_HISTOGRAM.addColumn(AVG_DURATION, JdkAggregators.AVG_BLOCKED_TIME);
        BY_ADDRESS_HISTOGRAM.addColumn(STD_DEV_DURATION, JdkAggregators.STDDEV_BLOCKED_TIME);
        BY_ADDRESS_HISTOGRAM.addColumn(JfrAttributes.EVENT_THREAD.getIdentifier(), BY_THREAD_AGGREGATOR);
        BY_ADDRESS_HISTOGRAM.addColumn(INFLATED_COUNT, JdkAggregators.TOTAL_INFLATED_COUNT);
        BY_ADDRESS_HISTOGRAM.addColumn(INFLATED_CAUSE, JdkAggregators.MONITOR_INFLATE_REASON);
        BY_THREAD_HISTOGRAM.addCountColumn();
        BY_THREAD_HISTOGRAM.addColumn(JfrAttributes.DURATION.getIdentifier(), JdkAggregators.TOTAL_BLOCKED_TIME);
        BY_THREAD_HISTOGRAM.addColumn(MAX_DURATION, JdkAggregators.MAX_BLOCKED_TIME);
        BY_THREAD_HISTOGRAM.addColumn(AVG_DURATION, JdkAggregators.AVG_BLOCKED_TIME);
        BY_THREAD_HISTOGRAM.addColumn(STD_DEV_DURATION, JdkAggregators.STDDEV_BLOCKED_TIME);
        BY_THREAD_HISTOGRAM.addColumn(INFLATED_COUNT, JdkAggregators.TOTAL_INFLATED_COUNT);
        BY_THREAD_HISTOGRAM.addColumn(INFLATED_CAUSE, JdkAggregators.MONITOR_INFLATE_REASON);
    }

    private static TableSettings getTableSettings(IState state) {
        if (state == null) {
            return new TableSettings(JfrAttributes.DURATION.getIdentifier(), Arrays.asList(new TableSettings.ColumnSettings("itemhistogram.key", Boolean.valueOf(false), Integer.valueOf(500), null)));
        }
        return new TableSettings(state);
    }

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer editor, IState state) {
        return new LockInstancesPageUi(parent, toolkit, editor, state);
    }

    @Override
    public IItemFilter getDefaultSelectionFilter() {
        return TABLE_ITEMS;
    }

    public LockInstancesPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
    }

    public static class LockInstancesPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.LockInstancesPage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/locks.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"lock_instances"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new LockInstancesPage(dpd, items, editor);
        }
    }

    private class LockInstancesPageUi
    implements IPageUI {
        private static final String CLASS_FILTER = "classFilter";
        private static final String ADDRESS_FILTER = "addressFilter";
        private static final String THREAD_FILTER = "threadFilter";
        private static final String SASH_ELEMENT = "sash";
        private static final String BY_CLASS_TABLE_ELEMENT = "byClassTable";
        private static final String BY_ADDRESS_TABLE_ELEMENT = "byClassTable";
        private static final String BY_THREAD_TABLE_ELEMENT = "byClassTable";
        private final ItemHistogram byClassTable;
        private final ItemHistogram byAddressTable;
        private final ItemHistogram byThreadTable;
        private final SashForm sash;
        private Consumer<IItemCollection> histogramChain;
        private FilterComponent byClassFilter;
        private FilterComponent byAddressFilter;
        private FilterComponent byThreadFilter;
        private FlavorSelector flavorSelector;
        private IItemCollection selectionItems;

        LockInstancesPageUi(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
            Form form = DataPageToolkit.createForm(parent, toolkit, LockInstancesPage.this.getName(), LockInstancesPage.this.getIcon());
            this.selectionItems = LockInstancesPage.this.getDataSource().getItems();
            this.sash = new SashForm(form.getBody(), 512);
            toolkit.adapt((Composite)this.sash);
            this.byClassTable = BY_CLASS_HISTOGRAM.buildWithoutBorder((Composite)this.sash, JdkAttributes.MONITOR_CLASS, LockInstancesPage.getTableSettings(state.getChild("byClassTable")));
            MCContextMenuManager mm = MCContextMenuManager.create((Control)this.byClassTable.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.byClassTable.getManager(), (MCContextMenuManager)mm);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.byClassTable, Messages.LockInstancesPage_CLASS_HISTOGRAM_SELECTION, (IContributionManager)mm);
            this.byClassFilter = FilterComponent.createFilterComponent(this.byClassTable, LockInstancesPage.this.byClassFilter, LockInstancesPage.this.getDataSource().getItems().apply(TABLE_ITEMS), pageContainer.getSelectionStore()::getSelections, this::onClassFilterChange);
            mm.add(this.byClassFilter.getShowFilterAction());
            mm.add(this.byClassFilter.getShowSearchAction());
            this.byAddressTable = BY_ADDRESS_HISTOGRAM.buildWithoutBorder((Composite)this.sash, JdkAttributes.MONITOR_ADDRESS, LockInstancesPage.getTableSettings(state.getChild("byClassTable")));
            mm = MCContextMenuManager.create((Control)this.byAddressTable.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.byAddressTable.getManager(), (MCContextMenuManager)mm);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.byAddressTable, Messages.LockInstancesPage_ADDRESS_HISTOGRAM_SELECTION, (IContributionManager)mm);
            this.byAddressFilter = FilterComponent.createFilterComponent(this.byAddressTable, LockInstancesPage.this.byAddressFilter, LockInstancesPage.this.getDataSource().getItems().apply(TABLE_ITEMS), pageContainer.getSelectionStore()::getSelections, this::onAddressFilterChange);
            mm.add(this.byAddressFilter.getShowFilterAction());
            mm.add(this.byAddressFilter.getShowSearchAction());
            this.byThreadTable = BY_THREAD_HISTOGRAM.buildWithoutBorder((Composite)this.sash, JfrAttributes.EVENT_THREAD, LockInstancesPage.getTableSettings(state.getChild("byClassTable")));
            mm = MCContextMenuManager.create((Control)this.byThreadTable.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.byThreadTable.getManager(), (MCContextMenuManager)mm);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.byThreadTable, Messages.LockInstancesPage_THREAD_HISTOGRAM_SELECTION, (IContributionManager)mm);
            this.byThreadFilter = FilterComponent.createFilterComponent(this.byThreadTable, LockInstancesPage.this.byThreadFilter, LockInstancesPage.this.getDataSource().getItems().apply(TABLE_ITEMS), pageContainer.getSelectionStore()::getSelections, this::onThreadFilterChange);
            mm.add(this.byThreadFilter.getShowFilterAction());
            mm.add(this.byThreadFilter.getShowSearchAction());
            this.histogramChain = ItemHistogramWithInput.chain(this.byClassTable, pageContainer::showSelection, this.byAddressTable, this.byThreadTable);
            PersistableSashForm.loadState((SashForm)this.sash, (IState)state.getChild(SASH_ELEMENT));
            this.flavorSelector = FlavorSelector.itemsWithTimerange(form, TABLE_ITEMS, LockInstancesPage.this.getDataSource().getItems(), pageContainer, this::onInputSelected, LockInstancesPage.this.flavorSelectorState);
            LockInstancesPage.this.addResultActions(form);
            this.byClassFilter.loadState(state.getChild(CLASS_FILTER));
            this.byAddressFilter.loadState(state.getChild(ADDRESS_FILTER));
            this.byThreadFilter.loadState(state.getChild(THREAD_FILTER));
            this.byClassTable.getManager().setSelectionState(LockInstancesPage.this.byClassState);
            this.onClassFilterChange(LockInstancesPage.this.byClassFilter);
            this.byAddressTable.getManager().setSelectionState(LockInstancesPage.this.byAddressState);
            this.onAddressFilterChange(LockInstancesPage.this.byAddressFilter);
            this.byThreadTable.getManager().setSelectionState(LockInstancesPage.this.byThreadState);
            this.onThreadFilterChange(LockInstancesPage.this.byThreadFilter);
        }

        private void onClassFilterChange(IItemFilter filter) {
            this.byClassFilter.filterChangeHelper(filter, this.byClassTable, this.selectionItems.apply(TABLE_ITEMS));
            LockInstancesPage.this.byClassFilter = filter;
            this.byAddressFilter.notifyListener();
            this.byThreadFilter.notifyListener();
        }

        private void onAddressFilterChange(IItemFilter filter) {
            this.byAddressFilter.filterChangeHelper(filter, this.byAddressTable, this.selectionItems.apply(TABLE_ITEMS));
            this.byThreadFilter.notifyListener();
            LockInstancesPage.this.byAddressFilter = filter;
        }

        private void onThreadFilterChange(IItemFilter filter) {
            this.byThreadFilter.filterChangeHelper(filter, this.byThreadTable, this.selectionItems.apply(TABLE_ITEMS));
            LockInstancesPage.this.byThreadFilter = filter;
        }

        public void saveTo(IWritableState writableState) {
            PersistableSashForm.saveState((SashForm)this.sash, (IWritableState)writableState.createChild(SASH_ELEMENT));
            this.byClassTable.getManager().getSettings().saveState(writableState.createChild("byClassTable"));
            this.byClassFilter.saveState(writableState.createChild(CLASS_FILTER));
            this.byAddressTable.getManager().getSettings().saveState(writableState.createChild("byClassTable"));
            this.byAddressFilter.saveState(writableState.createChild(ADDRESS_FILTER));
            this.byThreadTable.getManager().getSettings().saveState(writableState.createChild("byClassTable"));
            this.byThreadFilter.saveState(writableState.createChild(THREAD_FILTER));
            this.saveToLocal();
        }

        private void saveToLocal() {
            LockInstancesPage.this.byClassState = this.byClassTable.getManager().getSelectionState();
            LockInstancesPage.this.byAddressState = this.byAddressTable.getManager().getSelectionState();
            LockInstancesPage.this.byThreadState = this.byThreadTable.getManager().getSelectionState();
            LockInstancesPage.this.flavorSelectorState = this.flavorSelector.getFlavorSelectorState();
        }

        private void onInputSelected(IItemCollection items, IRange<IQuantity> timeRange) {
            this.selectionItems = items != null ? items.apply(TABLE_ITEMS) : LockInstancesPage.this.getDataSource().getItems().apply(TABLE_ITEMS);
            this.histogramChain.accept(this.selectionItems);
        }
    }
}

