/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.browser.attach.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import org.openjdk.jmc.browser.attach.BrowserAttachPlugin;

public class MonitoredVmWrapper {
    private static Class<?> CLASS_MONITORED_VM;
    private static Class<?> CLASS_MONITORED_VM_UTIL;
    private static Class<?> CLASS_STRING_MONITOR;
    private Object monitoredVm;

    static {
        try {
            CLASS_MONITORED_VM = Class.forName("sun.jvmstat.monitor.MonitoredVm");
            CLASS_MONITORED_VM_UTIL = Class.forName("sun.jvmstat.monitor.MonitoredVmUtil");
            CLASS_STRING_MONITOR = Class.forName("sun.jvmstat.monitor.StringMonitor");
        }
        catch (ClassNotFoundException e) {
            CLASS_MONITORED_VM = null;
            CLASS_MONITORED_VM_UTIL = null;
            CLASS_STRING_MONITOR = null;
            BrowserAttachPlugin.getPluginLogger().log(Level.WARNING, "Could not find attach related classes. This can affect discovery of locally running JVMs.", e);
        }
    }

    public MonitoredVmWrapper(Object monitoredVm) {
        this.monitoredVm = monitoredVm;
    }

    public String commandLine() {
        if (CLASS_MONITORED_VM_UTIL != null) {
            try {
                Method methodCommandLine = CLASS_MONITORED_VM_UTIL.getMethod("commandLine", CLASS_MONITORED_VM);
                Object commandLine = methodCommandLine.invoke(null, this.monitoredVm);
                return String.valueOf(commandLine);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                BrowserAttachPlugin.getPluginLogger().log(Level.FINEST, "Could not read command line!", e);
            }
        }
        return null;
    }

    public String jvmArgs() {
        if (CLASS_MONITORED_VM_UTIL != null) {
            try {
                Method methodCommandLine = CLASS_MONITORED_VM_UTIL.getMethod("jvmArgs", CLASS_MONITORED_VM);
                Object commandLine = methodCommandLine.invoke(null, this.monitoredVm);
                return String.valueOf(commandLine);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                BrowserAttachPlugin.getPluginLogger().log(Level.FINEST, "Could not read command line!", e);
            }
        }
        return null;
    }

    public String jvmName() {
        return this.getPropertyStringValue("java.property.java.vm.name");
    }

    public String javaVersion() {
        return this.getPropertyStringValue("java.property.java.version");
    }

    public String jvmVersion() {
        return this.getPropertyStringValue("java.property.java.vm.version");
    }

    public String jvmVendor() {
        return this.getPropertyStringValue("java.property.java.vm.vendor");
    }

    public void detach() {
        try {
            Method methodDetach = CLASS_MONITORED_VM.getMethod("detach", new Class[0]);
            methodDetach.invoke(this.monitoredVm, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            BrowserAttachPlugin.getPluginLogger().log(Level.FINEST, "Could not detach from monitored VM", e);
        }
    }

    private String getPropertyStringValue(String propertyName) {
        try {
            Method methodFindByName = CLASS_MONITORED_VM.getMethod("findByName", String.class);
            Object stringMonitor = methodFindByName.invoke(this.monitoredVm, propertyName);
            Method methodStringValue = CLASS_STRING_MONITOR.getMethod("stringValue", new Class[0]);
            return String.valueOf(methodStringValue.invoke(stringMonitor, new Object[0]));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            BrowserAttachPlugin.getPluginLogger().log(Level.FINEST, "Could not read StringMonitor " + propertyName, e);
            return null;
        }
    }
}

