/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.collection;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.openjdk.jmc.common.collection.IteratorToolkit;

public class FastAccessNumberMap<T>
implements Iterable<T> {
    private final int pagesUpperLimit;
    private Page[] pages;
    private Map<Long, T> overflow;

    public FastAccessNumberMap() {
        this(5000);
    }

    public FastAccessNumberMap(int expectedSize) {
        this.pagesUpperLimit = expectedSize + 64 - 1 & 0xFFFFFFC0;
        this.pages = new Page[1];
    }

    public FastAccessNumberMap(int pageSize, int maxPageCount) {
        this(pageSize * maxPageCount);
    }

    private Page getPage(int pageIndex) {
        Page page;
        if (this.pages.length <= pageIndex) {
            this.pages = Arrays.copyOf(this.pages, pageIndex + 1);
        }
        if ((page = this.pages[pageIndex]) == null) {
            this.pages[pageIndex] = page = new Page();
        }
        return page;
    }

    private T getLow(int index) {
        Object value;
        Object tValue = value = this.getPage(index / 64).get(index & 0x3F);
        return (T)tValue;
    }

    private void putLow(int index, T object) {
        this.getPage(index / 64).set(index & 0x3F, object);
    }

    public T get(long index) {
        if (index >= 0L && index < (long)this.pagesUpperLimit) {
            return this.getLow((int)index);
        }
        return this.getOverflowMap().get(index);
    }

    public void put(long index, T value) {
        if (index >= 0L && index < (long)this.pagesUpperLimit) {
            this.putLow((int)index, value);
        } else {
            this.getOverflowMap().put(index, value);
        }
    }

    private Map<Long, T> getOverflowMap() {
        if (this.overflow == null) {
            this.overflow = new HashMap<Long, T>();
        }
        return this.overflow;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            T next;
            Iterator<Page> pageIterator;
            PageIteratorFlyweight elementIterator;
            Iterator<T> highIterator;
            {
                this.pageIterator = IteratorToolkit.of(FastAccessNumberMap.this.pages);
                this.elementIterator = new PageIteratorFlyweight();
                this.highIterator = FastAccessNumberMap.this.overflow == null ? Collections.emptyList().iterator() : FastAccessNumberMap.this.overflow.values().iterator();
            }

            @Override
            public boolean hasNext() {
                while (this.next == null) {
                    if (!this.elementIterator.hasNext()) {
                        if (this.pageIterator.hasNext()) {
                            Page nextPage = this.pageIterator.next();
                            if (nextPage == null) continue;
                            this.elementIterator.wrap(nextPage);
                            continue;
                        }
                        if (this.highIterator.hasNext()) {
                            this.next = this.highIterator.next();
                            continue;
                        }
                        return false;
                    }
                    Object value = this.elementIterator.next();
                    this.next = value;
                }
                return true;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    Object tmp = this.next;
                    this.next = null;
                    return tmp;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static final class Page {
        public static final int SIZE = 64;
        private long mask;
        private final Object[] values = new Object[64];

        Page() {
        }

        public Object get(int index) {
            return this.values[index];
        }

        public void set(int index, Object value) {
            this.values[index] = value;
            this.mask |= 1L << index;
        }
    }

    private static final class PageIteratorFlyweight
    implements Iterator<Object> {
        private long mask;
        private Object[] values;

        private PageIteratorFlyweight() {
        }

        public void wrap(Page page) {
            this.mask = page.mask;
            this.values = page.values;
        }

        @Override
        public boolean hasNext() {
            return this.mask != 0L;
        }

        @Override
        public Object next() {
            int index = Long.numberOfTrailingZeros(this.mask);
            this.mask &= this.mask - 1L;
            return this.values[index];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

