/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.unit;

import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IScalarAffineTransform;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.KindOfQuantity;
import org.openjdk.jmc.common.unit.LinearUnit;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.common.unit.TypedUnit;

abstract class ScalarQuantity<U extends TypedUnit<U>>
extends Number
implements ITypedQuantity<U> {
    private static final long serialVersionUID = 1L;
    protected final U unit;

    protected ScalarQuantity(U unit) {
        this.unit = unit;
    }

    @Override
    public U getUnit() {
        return this.unit;
    }

    @Override
    public KindOfQuantity<U> getType() {
        return ((TypedUnit)this.unit).getContentType();
    }

    @Override
    public int compareTo(IQuantity other) {
        if (other instanceof ScalarQuantity) {
            try {
                return Double.compare(this.doubleValue(), other.doubleValueIn((IUnit)this.unit));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return ((TypedUnit)this.unit).getContentType().getIdentifier().compareTo(other.getUnit().getContentType().getIdentifier());
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @Override
    public long longValueIn(IUnit targetUnit) throws QuantityConversionException {
        return this.longValueIn(targetUnit, Long.MAX_VALUE);
    }

    @Override
    public final String interactiveFormat() {
        return this.localizedFormat(true, false);
    }

    @Override
    public final String interactiveFormat(boolean allowCustomUnit) {
        return this.localizedFormat(true, allowCustomUnit);
    }

    @Override
    public String displayUsing(String formatIdentifier) {
        return ((TypedUnit)this.unit).getContentType().getFormatter(formatIdentifier).format(this);
    }

    @Override
    public boolean isLinear() {
        return this.unit.isLinear();
    }

    @Override
    public IQuantity add(IQuantity addend) throws IllegalArgumentException {
        if (!addend.isLinear()) {
            if (this.isLinear()) {
                return addend.add(this);
            }
            throw new IllegalArgumentException("Absolute quantities like " + addend + " cannot be added to " + this + ".");
        }
        ITypedQuantity linearAddend = (ITypedQuantity)addend;
        return this.add(linearAddend);
    }

    @Override
    public IQuantity subtract(IQuantity subtrahend) throws IllegalArgumentException {
        if (subtrahend.isLinear()) {
            ITypedQuantity linearSubtrahend = (ITypedQuantity)subtrahend;
            return this.subtractLinear(linearSubtrahend);
        }
        ITypedQuantity typedSubtrahend = (ITypedQuantity)subtrahend;
        return this.subtract(typedSubtrahend);
    }

    protected abstract ITypedQuantity<U> subtractLinear(ITypedQuantity<LinearUnit> var1);

    public static class DoubleStored<U extends TypedUnit<U>>
    extends ScalarQuantity<U> {
        private static final long serialVersionUID = 1L;
        private final double numericalValue;

        protected DoubleStored(double numericalValue, U unit) {
            super(unit);
            this.numericalValue = numericalValue;
        }

        @Override
        public int intValue() {
            return (int)this.numericalValue;
        }

        @Override
        public long longValue() {
            return (long)this.numericalValue;
        }

        @Override
        public float floatValue() {
            return (float)this.numericalValue;
        }

        @Override
        public double doubleValue() {
            return this.numericalValue;
        }

        @Override
        public Number numberValue() {
            return this.numericalValue;
        }

        @Override
        public IQuantity in(IUnit targetUnit) {
            if (targetUnit == this.unit) {
                return this;
            }
            return targetUnit.quantity(this.doubleValueIn(targetUnit));
        }

        @Override
        public ITypedQuantity<U> in(U targetUnit) {
            if (targetUnit == this.unit) {
                return this;
            }
            return ((TypedUnit)targetUnit).quantity(this.doubleValueIn((IUnit)targetUnit));
        }

        @Override
        public long longValueIn(IUnit targetUnit, long maxAbsValue) throws QuantityConversionException {
            IScalarAffineTransform factor = this.unit.valueTransformTo(targetUnit);
            if (factor.targetOutOfRange(this.numericalValue, maxAbsValue)) {
                if (this.numericalValue < 0.0) {
                    throw QuantityConversionException.tooLow(this, targetUnit.quantity(maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL));
                }
                throw QuantityConversionException.tooHigh(this, targetUnit.quantity(maxAbsValue));
            }
            return (long)factor.targetValue(this.numericalValue);
        }

        @Override
        public long clampedLongValueIn(IUnit targetUnit) {
            return (long)this.unit.valueTransformTo(targetUnit).targetValue(this.numericalValue);
        }

        @Override
        public long clampedFloorIn(IUnit targetUnit) {
            return (long)this.unit.valueTransformTo(targetUnit).targetFloor(this.numericalValue);
        }

        @Override
        public int clampedIntFloorIn(IUnit targetUnit) {
            return this.unit.valueTransformTo(targetUnit).targetIntFloor(this.numericalValue);
        }

        @Override
        public double doubleValueIn(IUnit targetUnit) {
            return this.unit.valueTransformTo(targetUnit).targetValue(this.numericalValue);
        }

        @Override
        public Number numberValueIn(IUnit targetUnit) {
            return this.unit.valueTransformTo(targetUnit).targetValue(this.numericalValue);
        }

        @Override
        public ITypedQuantity<U> floorQuantize(ITypedQuantity<LinearUnit> quanta) {
            return this.unit.floorQuantize(this.numericalValue, quanta);
        }

        @Override
        public String persistableString() {
            return this.unit.persistableStringFor(this.numericalValue);
        }

        @Override
        public String localizedFormat(boolean useBreakingSpace, boolean allowCustomUnit) {
            return this.unit.localizedFormatFor(this.numericalValue, useBreakingSpace, allowCustomUnit);
        }

        @Override
        public int hashCode() {
            long bits = Double.doubleToLongBits(this.numericalValue);
            return (int)(bits ^ bits >>> 32);
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof DoubleStored) {
                DoubleStored otherQuantity = (DoubleStored)other;
                return this.numericalValue == otherQuantity.numericalValue && this.unit.equals(otherQuantity.unit);
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this.numericalValue) + this.unit.toString();
        }

        @Override
        public ITypedQuantity<U> add(ITypedQuantity<LinearUnit> addend) throws IllegalArgumentException {
            return this.unit.quantity(this.numericalValue + addend.doubleValueIn(this.unit.getDeltaUnit()));
        }

        @Override
        protected ITypedQuantity<U> subtractLinear(ITypedQuantity<LinearUnit> subtrahend) {
            return this.unit.quantity(this.numericalValue - subtrahend.doubleValueIn(this.unit.getDeltaUnit()));
        }

        @Override
        public ITypedQuantity<LinearUnit> subtract(ITypedQuantity<U> subtrahend) throws IllegalArgumentException {
            return this.unit.getDeltaUnit().quantity(this.numericalValue - subtrahend.doubleValueIn(this.unit));
        }

        @Override
        public ITypedQuantity<U> multiply(long factor) throws UnsupportedOperationException {
            if (!this.isLinear()) {
                throw new UnsupportedOperationException("Multiplication of non-linear quantities like " + this + " is not supported.");
            }
            return this.unit.quantity(this.numericalValue * (double)factor);
        }

        @Override
        public ITypedQuantity<U> multiply(double factor) throws UnsupportedOperationException {
            if (!this.isLinear()) {
                throw new UnsupportedOperationException("Multiplication of non-linear quantities like " + this + " is not supported.");
            }
            return this.unit.quantity(this.numericalValue * factor);
        }

        @Override
        public double ratioTo(IQuantity denominator) throws UnsupportedOperationException, IllegalArgumentException {
            if (!this.isLinear()) {
                throw new UnsupportedOperationException("Ratios are not defined for non-linear quantities like " + this);
            }
            return this.numericalValue / denominator.doubleValueIn(this.unit);
        }
    }

    public static class LongStored<U extends TypedUnit<U>>
    extends ScalarQuantity<U> {
        private static final long serialVersionUID = 1L;
        private final long numericalValue;

        protected LongStored(long numericalValue, U unit) {
            super(unit);
            this.numericalValue = numericalValue;
        }

        @Override
        public int intValue() {
            return (int)this.numericalValue;
        }

        @Override
        public long longValue() {
            return this.numericalValue;
        }

        @Override
        public float floatValue() {
            return this.numericalValue;
        }

        @Override
        public double doubleValue() {
            return this.numericalValue;
        }

        @Override
        public Number numberValue() {
            return this.numericalValue;
        }

        @Override
        public IQuantity in(IUnit targetUnit) {
            if (this.unit == targetUnit) {
                return this;
            }
            IScalarAffineTransform transform = this.unit.valueTransformTo(targetUnit);
            if (transform.targetOutOfRange(this.numericalValue, Long.MAX_VALUE)) {
                return targetUnit.quantity(this.doubleValueIn(targetUnit));
            }
            return targetUnit.quantity(this.clampedLongValueIn(targetUnit));
        }

        @Override
        public ITypedQuantity<U> in(U targetUnit) {
            if (this.unit == targetUnit) {
                return this;
            }
            IScalarAffineTransform transform = this.unit.valueTransformTo(targetUnit);
            if (transform.targetOutOfRange(this.numericalValue, Long.MAX_VALUE)) {
                return ((TypedUnit)targetUnit).quantity(this.doubleValueIn((IUnit)targetUnit));
            }
            return ((TypedUnit)targetUnit).quantity(this.clampedLongValueIn((IUnit)targetUnit));
        }

        @Override
        public long longValueIn(IUnit targetUnit, long maxAbsValue) throws QuantityConversionException {
            IScalarAffineTransform transform = this.unit.valueTransformTo(targetUnit);
            if (transform.targetOutOfRange(this.numericalValue, maxAbsValue)) {
                if (this.numericalValue < 0L) {
                    throw QuantityConversionException.tooLow(this, targetUnit.quantity(maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL));
                }
                throw QuantityConversionException.tooHigh(this, targetUnit.quantity(maxAbsValue));
            }
            return transform.targetValue(this.numericalValue);
        }

        @Override
        public long clampedLongValueIn(IUnit targetUnit) {
            return this.unit.valueTransformTo(targetUnit).targetValue(this.numericalValue);
        }

        @Override
        public long clampedFloorIn(IUnit targetUnit) {
            return this.unit.valueTransformTo(targetUnit).targetFloor(this.numericalValue);
        }

        @Override
        public int clampedIntFloorIn(IUnit targetUnit) {
            return this.unit.valueTransformTo(targetUnit).targetIntFloor(this.numericalValue);
        }

        @Override
        public double doubleValueIn(IUnit targetUnit) {
            return this.unit.valueTransformTo(targetUnit).targetValue((double)this.numericalValue);
        }

        @Override
        public Number numberValueIn(IUnit targetUnit) {
            return this.unit.valueTransformTo(targetUnit).targetNumber(this.numericalValue);
        }

        @Override
        public ITypedQuantity<U> floorQuantize(ITypedQuantity<LinearUnit> quanta) {
            return this.unit.floorQuantize(this.numericalValue, quanta);
        }

        @Override
        public String persistableString() {
            return this.unit.persistableStringFor(this.numericalValue);
        }

        @Override
        public String localizedFormat(boolean useBreakingSpace, boolean allowCustomUnit) {
            return this.unit.localizedFormatFor(this.numericalValue, useBreakingSpace, allowCustomUnit);
        }

        @Override
        public int hashCode() {
            return (int)this.numericalValue;
        }

        @Override
        public int compareTo(IQuantity other) {
            if (other instanceof LongStored && this.unit.equals(other.getUnit())) {
                long otherVal = ((LongStored)other).numericalValue;
                return this.numericalValue == otherVal ? 0 : (this.numericalValue < otherVal ? -1 : 1);
            }
            return super.compareTo(other);
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof LongStored) {
                LongStored otherQuantity = (LongStored)other;
                return this.numericalValue == otherQuantity.numericalValue && this.unit.equals(otherQuantity.unit);
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this.numericalValue) + this.unit.toString();
        }

        @Override
        public ITypedQuantity<U> add(ITypedQuantity<LinearUnit> addend) throws IllegalArgumentException {
            if (addend instanceof LongStored) {
                return this.unit.add(this.numericalValue, (LinearUnit)addend.getUnit(), addend.longValue());
            }
            return this.unit.quantity((double)this.numericalValue + addend.doubleValueIn(this.unit.getDeltaUnit()));
        }

        @Override
        protected ITypedQuantity<U> subtractLinear(ITypedQuantity<LinearUnit> subtrahend) {
            if (subtrahend instanceof LongStored) {
                return this.unit.add(this.numericalValue, (LinearUnit)subtrahend.getUnit(), -subtrahend.longValue());
            }
            return this.unit.quantity((double)this.numericalValue - subtrahend.doubleValueIn(this.unit.getDeltaUnit()));
        }

        @Override
        public ITypedQuantity<LinearUnit> subtract(ITypedQuantity<U> subtrahend) throws IllegalArgumentException {
            if (subtrahend instanceof LongStored) {
                return this.unit.subtractSame(this.numericalValue, subtrahend.getUnit(), subtrahend.longValue());
            }
            return this.unit.getDeltaUnit().quantity((double)this.numericalValue - subtrahend.doubleValueIn(this.unit));
        }

        @Override
        public ITypedQuantity<U> multiply(long factor) throws UnsupportedOperationException {
            if (!this.isLinear()) {
                throw new UnsupportedOperationException("Multiplication of non-linear quantities like " + this + " is not supported.");
            }
            return this.unit.quantity(this.numericalValue * factor);
        }

        @Override
        public ITypedQuantity<U> multiply(double factor) throws UnsupportedOperationException {
            if (!this.isLinear()) {
                throw new UnsupportedOperationException("Multiplication of non-linear quantities like " + this + " is not supported.");
            }
            return this.unit.quantity((double)this.numericalValue * factor);
        }

        @Override
        public double ratioTo(IQuantity denominator) throws UnsupportedOperationException, IllegalArgumentException {
            if (!this.isLinear()) {
                throw new UnsupportedOperationException("Ratios are not defined for non-linear quantities like " + this);
            }
            return (double)this.numericalValue / denominator.doubleValueIn(this.unit);
        }
    }
}

