/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.stacktrace;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.collection.ArrayToolkit;
import org.openjdk.jmc.common.collection.SimpleArray;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemToolkit;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.util.MCFrame;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceFrame;

public class StacktraceModel {
    private final IMemberAccessor<IMCStackTrace, IItem> accessor = ItemToolkit.accessor(JfrAttributes.EVENT_STACKTRACE);
    private final boolean threadRootAtTop;
    private final FrameSeparator frameSeparator;
    private final IItemCollection items;
    private final IAttribute<IQuantity> attribute;
    private Fork rootFork;
    public static final IMCFrame UNKNOWN_FRAME = new MCFrame(null, null, null, IMCFrame.Type.UNKNOWN);
    private static final Comparator<FrameEntry> COUNT_CMP = new Comparator<FrameEntry>(){

        @Override
        public int compare(FrameEntry o1, FrameEntry o2) {
            return o2.items.size() - o1.items.size();
        }
    };

    public StacktraceModel(boolean threadRootAtTop, FrameSeparator frameSeparator, IItemCollection items) {
        this(threadRootAtTop, frameSeparator, items, null);
    }

    public StacktraceModel(boolean threadRootAtTop, FrameSeparator frameSeparator, IItemCollection items, IAttribute<IQuantity> attribute) {
        this.threadRootAtTop = threadRootAtTop;
        this.frameSeparator = frameSeparator;
        this.items = items;
        this.attribute = attribute;
    }

    public int hashCode() {
        return Objects.hash(this.frameSeparator, this.items, this.threadRootAtTop);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StacktraceModel) {
            StacktraceModel other = (StacktraceModel)obj;
            return this.threadRootAtTop == other.threadRootAtTop && this.frameSeparator.equals(other.frameSeparator) && this.items.equals(other.items) && Objects.equals(this.attribute, other.attribute);
        }
        return false;
    }

    public Fork getRootFork() {
        if (this.rootFork == null) {
            this.rootFork = new Fork(ItemToolkit.asIterable((IItemCollection)this.items));
        }
        return this.rootFork;
    }

    static IMemberAccessor<IQuantity, IItem> getAccessor(SimpleArray<IItem> items, IAttribute<IQuantity> attribute) {
        if (items.size() > 0 && attribute != null) {
            IType type = ((IItem)items.get(0)).getType();
            return type.getAccessor(attribute.getKey());
        }
        return null;
    }

    static IQuantity aggregateItems(SimpleArray<IItem> items, IMemberAccessor<IQuantity, IItem> accessor) {
        IQuantity quantity = null;
        for (IItem item : items) {
            IQuantity value = (IQuantity)accessor.getMember((Object)item);
            quantity = quantity == null ? value : quantity.add(value);
        }
        return quantity;
    }

    private IMCFrame getFrame(IItem item, int frameIndex) {
        IMCStackTrace st = (IMCStackTrace)this.accessor.getMember((Object)item);
        if (st != null) {
            if (this.threadRootAtTop && frameIndex == 0 && st.getTruncationState().isTruncated()) {
                return UNKNOWN_FRAME;
            }
            List frames = st.getFrames();
            if (frames != null && frameIndex < frames.size()) {
                return (IMCFrame)frames.get(this.threadRootAtTop ? frames.size() - 1 - frameIndex : frameIndex);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private List<FrameEntry> getDistinctFrames(int frameIndex, Iterable<? extends IItem> items) {
        void var7_9;
        HashMap<Object, SimpleArray> categories = new HashMap<Object, SimpleArray>(2000);
        Object lastCategory = null;
        SimpleArray lastCategoryEntries = null;
        for (IItem iItem : items) {
            IMCFrame frame = this.getFrame(iItem, frameIndex);
            if (frame == null) continue;
            Object category = this.frameSeparator.getCategory(frame);
            if (!category.equals(lastCategory)) {
                lastCategoryEntries = (SimpleArray)categories.get(category);
                lastCategory = category;
                if (lastCategoryEntries == null) {
                    lastCategoryEntries = new SimpleArray((Object[])new FrameEntry[1]);
                    categories.put(category, lastCategoryEntries);
                }
            }
            StacktraceModel.findEntryForFrame((SimpleArray<FrameEntry>)lastCategoryEntries, (IMCFrame)frame, (FrameSeparator)this.frameSeparator).items.add((Object)iItem);
        }
        Collection feArrays = categories.values();
        boolean bl = false;
        for (SimpleArray fes : feArrays) {
            var7_9 += fes.size();
        }
        ArrayList<FrameEntry> distinctFrames = new ArrayList<FrameEntry>((int)var7_9);
        for (SimpleArray fes : feArrays) {
            for (FrameEntry fe : fes) {
                distinctFrames.add(fe);
            }
        }
        return distinctFrames;
    }

    private static FrameEntry findEntryForFrame(SimpleArray<FrameEntry> entries, IMCFrame frame, FrameSeparator frameSeparator) {
        for (FrameEntry e : entries) {
            if (!frameSeparator.compareDetails(e.frame, frame)) continue;
            return e;
        }
        FrameEntry newEntry = new FrameEntry(frame);
        entries.add((Object)newEntry);
        return newEntry;
    }

    private static int countFramesOnOrAbove(Branch branch) {
        if (branch != null) {
            return StacktraceModel.countFramesOnOrAbove(branch.getParentFork().getParentBranch()) + 1 + branch.getTailFrames().length;
        }
        return 0;
    }

    public class Fork {
        private final Branch parentBranch;
        private final Branch[] branches;
        private final long itemOffset;
        private final int itemsInFork;
        private final long aggregateItemsInFork;
        private Integer selectedBranchIndex;
        private final SimpleArray<IItem> allItems;

        private Fork(Branch parentBranch) {
            this((Iterable<? extends IItem>)parentBranch.getLastFrame().getItems(), parentBranch.getParentFork().itemOffset + parentBranch.itemOffsetInFork, parentBranch);
        }

        private Fork(Iterable<? extends IItem> items) {
            this(items, 0L, null);
        }

        private Fork(Iterable<? extends IItem> items, long itemOffset, Branch parentBranch) {
            this.itemOffset = itemOffset;
            this.parentBranch = parentBranch;
            List<FrameEntry> branchHeadFrames = StacktraceModel.this.getDistinctFrames(StacktraceModel.countFramesOnOrAbove(parentBranch), items);
            branchHeadFrames.sort(COUNT_CMP);
            int itemsInFork = 0;
            long aggregateValue = 0L;
            SimpleArray allItems = new SimpleArray((Object[])new IItem[0]);
            SimpleArray branches = new SimpleArray((Object[])new Branch[branchHeadFrames.size()]);
            for (FrameEntry fe : branchHeadFrames) {
                Branch b = new Branch(this, fe.items, fe.frame, branches.size(), aggregateValue);
                itemsInFork += fe.items.size();
                IMemberAccessor<IQuantity, IItem> memberAccessor = StacktraceModel.getAccessor(fe.items, StacktraceModel.this.attribute);
                if (memberAccessor != null) {
                    IQuantity quantity = StacktraceModel.aggregateItems(fe.items, memberAccessor);
                    if (quantity != null) {
                        aggregateValue += quantity.longValue();
                    }
                } else {
                    aggregateValue += (long)fe.items.size();
                }
                if (allItems != null) {
                    allItems.addAll((Object[])((IItem[])fe.items.elements()));
                } else {
                    allItems = new SimpleArray((Object[])((IItem[])fe.items.elements()));
                }
                branches.add((Object)b);
            }
            this.selectedBranchIndex = branches.size() > 0 ? Integer.valueOf(0) : null;
            this.branches = (Branch[])branches.elements();
            this.itemsInFork = itemsInFork;
            this.aggregateItemsInFork = aggregateValue;
            this.allItems = allItems;
        }

        public long getItemOffset() {
            return this.itemOffset;
        }

        public int getItemsInFork() {
            return this.itemsInFork;
        }

        public long getAggregateItemsInFork() {
            return this.aggregateItemsInFork;
        }

        public SimpleArray<IItem> getAllItemsInFork() {
            return this.allItems;
        }

        public Branch getParentBranch() {
            return this.parentBranch;
        }

        public int getBranchCount() {
            return this.branches.length;
        }

        @Deprecated
        public Branch getSelectedBranch() {
            return this.selectedBranchIndex != null ? this.branches[this.selectedBranchIndex] : null;
        }

        public Branch getBranch(int branchIndex) {
            return this.branches[branchIndex];
        }

        public Branch[] getBranches() {
            return this.branches;
        }

        public StacktraceFrame[] getFirstFrames() {
            StacktraceFrame[] firstFrames = new StacktraceFrame[this.branches.length];
            for (int i = 0; i < this.branches.length; ++i) {
                firstFrames[i] = this.branches[i].getFirstFrame();
            }
            return firstFrames;
        }

        @Deprecated
        public void selectBranch(Integer branchIndex) {
            if (this.parentBranch != null) {
                this.parentBranch.selectSibling(0);
            }
            this.selectedBranchIndex = branchIndex;
        }
    }

    private static class FrameEntry {
        final SimpleArray<IItem> items = new SimpleArray((Object[])new IItem[3]);
        final IMCFrame frame;

        FrameEntry(IMCFrame frame) {
            this.frame = frame;
        }
    }

    public class Branch {
        private final Fork parentFork;
        private final StacktraceFrame firstFrame;
        private final int siblingIndex;
        private final long itemOffsetInFork;
        private Boolean hasTail;
        private StacktraceFrame[] tailFrames;
        private Fork branchEnding;

        private Branch(Fork parent, SimpleArray<IItem> items, IMCFrame frame, int siblingIndex, long itemOffsetInFork) {
            this.parentFork = parent;
            this.siblingIndex = siblingIndex;
            this.itemOffsetInFork = itemOffsetInFork;
            this.firstFrame = new StacktraceFrame(items, frame, this, 0, StacktraceModel.this.attribute);
        }

        public long getItemOffsetInFork() {
            return this.itemOffsetInFork;
        }

        public Fork getParentFork() {
            return this.parentFork;
        }

        public boolean hasTail() {
            if (this.hasTail == null) {
                this.hasTail = this.calculateHasTail();
            }
            return this.hasTail;
        }

        @Deprecated
        public Branch selectSibling(Integer siblingOffset) {
            if (siblingOffset == null) {
                this.parentFork.selectBranch(null);
                return null;
            }
            Branch[] siblings = this.parentFork.branches;
            int selectedSibling = Math.max(0, Math.min(siblings.length - 1, this.siblingIndex + siblingOffset));
            this.parentFork.selectBranch(selectedSibling);
            return siblings[selectedSibling];
        }

        public StacktraceFrame getFirstFrame() {
            return this.firstFrame;
        }

        public StacktraceFrame getLastFrame() {
            StacktraceFrame[] tail = this.getTailFrames();
            return tail.length > 0 ? tail[tail.length - 1] : this.firstFrame;
        }

        public StacktraceFrame[] getTailFrames() {
            if (this.tailFrames == null) {
                this.tailFrames = this.buildTail();
            }
            return this.tailFrames;
        }

        public Fork getEndFork() {
            if (this.branchEnding == null) {
                this.branchEnding = new Fork(this);
            }
            return this.branchEnding;
        }

        private boolean calculateHasTail() {
            int firstTailFrameIndex = StacktraceModel.countFramesOnOrAbove(this.parentFork.getParentBranch()) + 1;
            for (IItem item : this.firstFrame.getItems()) {
                IMCFrame frame = StacktraceModel.this.getFrame(item, firstTailFrameIndex);
                if (frame == null) continue;
                return true;
            }
            return false;
        }

        private StacktraceFrame[] buildTail() {
            SimpleArray tail = new SimpleArray((Object[])new StacktraceFrame[5]);
            int nextIndex = StacktraceModel.countFramesOnOrAbove(this.parentFork.getParentBranch()) + 1;
            StacktraceFrame node = this.firstFrame;
            while (true) {
                ArrayList<Integer> removeIndexes = new ArrayList<Integer>();
                IMCFrame commonFrame = null;
                int itemIndex = 0;
                for (IItem item : node.getItems()) {
                    IMCFrame frame = StacktraceModel.this.getFrame(item, nextIndex);
                    if (frame == null) {
                        removeIndexes.add(itemIndex);
                    } else if (commonFrame == null) {
                        commonFrame = frame;
                    } else if (StacktraceModel.this.frameSeparator.isSeparate(commonFrame, frame)) {
                        return (StacktraceFrame[])tail.elements();
                    }
                    ++itemIndex;
                }
                if (commonFrame == null) {
                    return (StacktraceFrame[])tail.elements();
                }
                if (removeIndexes.isEmpty()) {
                    node = new StacktraceFrame(node.getItems(), commonFrame, this, tail.size() + 1, StacktraceModel.this.attribute);
                } else {
                    IItem[] subset = (IItem[])ArrayToolkit.filter((Object[])((IItem[])node.getItems().elements()), removeIndexes);
                    node = new StacktraceFrame(subset, commonFrame, this, tail.size() + 1, StacktraceModel.this.attribute);
                }
                tail.add((Object)node);
                ++nextIndex;
            }
        }
    }
}

