/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.manager.model;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.openjdk.jmc.console.agent.AgentPlugin;
import org.openjdk.jmc.console.agent.manager.model.IPresetStorageDelegate;
import org.openjdk.jmc.console.agent.manager.model.LocalStorageDelegate;
import org.openjdk.jmc.console.agent.manager.model.Preset;
import org.openjdk.jmc.console.agent.manager.model.PresetRepository;
import org.xml.sax.SAXException;

public class PresetRepositoryFactory {
    static final String PRESET_FILE_EXTENSION = ".xml";
    private static final File PRESET_STORAGE_DIR = AgentPlugin.getDefault().getStateLocation().append(".presets").toFile();
    private static volatile PresetRepository singleton;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PresetRepository createSingleton() {
        if (singleton != null) return singleton;
        Class<PresetRepositoryFactory> clazz = PresetRepositoryFactory.class;
        synchronized (PresetRepositoryFactory.class) {
            if (singleton != null) return singleton;
            singleton = PresetRepositoryFactory.create();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    protected static PresetRepository create() {
        PresetRepository repository = new PresetRepository();
        PresetRepositoryFactory.initiate(repository);
        return repository;
    }

    protected static void initiate(PresetRepository repository) {
        PresetRepositoryFactory.addLocalPresetTo(repository);
    }

    private static void addLocalPresetTo(PresetRepository repository) {
        File localDir = PRESET_STORAGE_DIR;
        if (!localDir.isDirectory()) {
            return;
        }
        File[] files = localDir.listFiles((dir, name) -> name.endsWith(PRESET_FILE_EXTENSION));
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.length() == 0L) {
                AgentPlugin.getDefault().getLogger().log(Level.FINE, "Empty file in preset storage directory: " + file.getPath());
            } else {
                IPresetStorageDelegate delegate = LocalStorageDelegate.getDelegate(file);
                try {
                    Preset preset = new Preset(repository, delegate);
                    repository.addPreset(preset);
                }
                catch (IOException | SAXException e) {
                    AgentPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not add local XML config", e);
                }
            }
            ++n2;
        }
    }

    public static File getCreatedStorageDir() throws IOException {
        if (!PRESET_STORAGE_DIR.isDirectory() && !PRESET_STORAGE_DIR.mkdir()) {
            throw new IOException("Could not create the directory " + PRESET_STORAGE_DIR.toString());
        }
        return PRESET_STORAGE_DIR;
    }
}

