/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.jdk;

import java.util.function.Predicate;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.util.PredicateToolkit;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;

public final class JdkFilters {
    public static final IItemFilter SOCKET_READ = ItemFilters.type((String)"jdk.SocketRead");
    public static final IItemFilter SOCKET_WRITE = ItemFilters.type((String)"jdk.SocketWrite");
    public static final IItemFilter SOCKET_READ_OR_WRITE = ItemFilters.or((IItemFilter[])new IItemFilter[]{SOCKET_READ, SOCKET_WRITE});
    public static final IItemFilter NO_RMI_SOCKET_READ = ItemFilters.and((IItemFilter[])new IItemFilter[]{SOCKET_READ, ItemFilters.not((IItemFilter)new MethodFilter("sun.rmi.transport.tcp.TCPTransport", "handleMessages")), ItemFilters.not((IItemFilter)new MethodFilter("javax.management.remote.rmi.RMIConnector$RMINotifClient", "fetchNotifs"))});
    public static final IItemFilter NO_RMI_SOCKET_WRITE = ItemFilters.and((IItemFilter[])new IItemFilter[]{SOCKET_WRITE, ItemFilters.not((IItemFilter)new MethodFilter("sun.rmi.transport.tcp.TCPTransport$ConnectionHandler", "run")), ItemFilters.not((IItemFilter)new MethodFilter("sun.rmi.transport.tcp.TCPTransport$ConnectionHandler", "run0"))});
    public static final IItemFilter ENVIRONMENT_VARIABLE = ItemFilters.type((String)"jdk.InitialEnvironmentVariable");
    public static final IItemFilter FILE_READ = ItemFilters.type((String)"jdk.FileRead");
    public static final IItemFilter FILE_WRITE = ItemFilters.type((String)"jdk.FileWrite");
    public static final IItemFilter FILE_FORCE = ItemFilters.type((String)"jdk.FileForce");
    public static final IItemFilter CODE_CACHE_FULL = ItemFilters.type((String)"jdk.CodeCacheFull");
    public static final IItemFilter CODE_CACHE_STATISTICS = ItemFilters.type((String)"jdk.CodeCacheStatistics");
    public static final IItemFilter CODE_CACHE_CONFIGURATION = ItemFilters.type((String)"jdk.CodeCacheConfiguration");
    public static final IItemFilter SWEEP_CODE_CACHE = ItemFilters.type((String)"jdk.SweepCodeCache");
    public static final IItemFilter CODE_CACHE = ItemFilters.or((IItemFilter[])new IItemFilter[]{CODE_CACHE_FULL, CODE_CACHE_STATISTICS, SWEEP_CODE_CACHE, CODE_CACHE_CONFIGURATION});
    public static final IItemFilter CPU_INFORMATION = ItemFilters.type((String)"jdk.CPUInformation");
    public static final IItemFilter GC_CONFIG = ItemFilters.type((String)"jdk.GCConfiguration");
    public static final IItemFilter HEAP_CONFIG = ItemFilters.type((String)"jdk.GCHeapConfiguration");
    public static final IItemFilter BEFORE_GC = ItemFilters.equals(JdkAttributes.GC_WHEN, (Object)"Before GC");
    public static final IItemFilter AFTER_GC = ItemFilters.equals(JdkAttributes.GC_WHEN, (Object)"After GC");
    public static final IItemFilter ALLOC_OUTSIDE_TLAB = ItemFilters.type((String)"jdk.ObjectAllocationOutsideTLAB");
    public static final IItemFilter ALLOC_INSIDE_TLAB = ItemFilters.type((String)"jdk.ObjectAllocationInNewTLAB");
    public static final IItemFilter ALLOC_ALL = ItemFilters.type((String[])new String[]{"jdk.ObjectAllocationInNewTLAB", "jdk.ObjectAllocationOutsideTLAB"});
    public static final IItemFilter OBJ_ALLOC = ItemFilters.type((String)"jdk.ObjectAllocationSample");
    public static final IItemFilter REFERENCE_STATISTICS = ItemFilters.type((String)"jdk.GCReferenceStatistics");
    public static final IItemFilter GARBAGE_COLLECTION = ItemFilters.type((String)"jdk.GarbageCollection");
    public static final IItemFilter OLD_GARBAGE_COLLECTION = ItemFilters.type((String)"jdk.OldGarbageCollection");
    public static final IItemFilter YOUNG_GARBAGE_COLLECTION = ItemFilters.type((String)"jdk.YoungGarbageCollection");
    public static final IItemFilter CONCURRENT_MODE_FAILURE = ItemFilters.type((String)"jdk.ConcurrentModeFailure");
    public static final IItemFilter ERRORS = ItemFilters.type((String)"jdk.JavaErrorThrow");
    public static final IItemFilter EXCEPTIONS = ItemFilters.type((String)"jdk.JavaExceptionThrow");
    public static final IItemFilter THROWABLES = ItemFilters.or((IItemFilter[])new IItemFilter[]{EXCEPTIONS, ERRORS});
    public static final IItemFilter THROWABLES_STATISTICS = ItemFilters.type((String)"jdk.ExceptionStatistics");
    public static final IItemFilter CLASS_UNLOAD = ItemFilters.type((String)"jdk.ClassUnload");
    public static final IItemFilter CLASS_LOAD_STATISTICS = ItemFilters.type((String)"jdk.ClassLoadingStatistics");
    public static final IItemFilter CLASS_LOADER_STATISTICS = ItemFilters.type((String)"jdk.ClassLoaderStatistics");
    public static final IItemFilter CLASS_LOAD = ItemFilters.type((String)"jdk.ClassLoad");
    public static final IItemFilter CLASS_LOAD_OR_UNLOAD = ItemFilters.or((IItemFilter[])new IItemFilter[]{CLASS_LOAD, CLASS_UNLOAD});
    public static final IItemFilter CLASS_DEFINE = ItemFilters.type((String)"jdk.ClassDefine");
    public static final IItemFilter CLASS_LOADER_EVENTS = ItemFilters.or((IItemFilter[])new IItemFilter[]{CLASS_LOAD, CLASS_UNLOAD, CLASS_DEFINE, CLASS_LOADER_STATISTICS});
    public static final IItemFilter MONITOR_ENTER = ItemFilters.type((String)"jdk.JavaMonitorEnter");
    public static final IItemFilter MONITOR_INFLATE = ItemFilters.type((String)"jdk.JavaMonitorInflate");
    public static final IItemFilter FILE_OR_SOCKET_IO = ItemFilters.type((String[])new String[]{"jdk.SocketRead", "jdk.SocketWrite", "jdk.FileRead", "jdk.FileWrite"});
    public static final IItemFilter THREAD_LATENCIES = ItemFilters.type((String[])new String[]{"jdk.JavaMonitorEnter", "jdk.JavaMonitorWait", "jdk.ThreadSleep", "jdk.ThreadPark", "jdk.SocketRead", "jdk.SocketWrite", "jdk.FileRead", "jdk.FileWrite", "jdk.ClassLoad", "jdk.Compilation", "jdk.ExecutionSampling"});
    public static final IItemFilter EXECUTION_SAMPLE = ItemFilters.type((String)"jdk.ExecutionSample");
    public static final IItemFilter CONTEXT_SWITCH_RATE = ItemFilters.type((String)"jdk.ThreadContextSwitchRate");
    public static final IItemFilter CPU_LOAD = ItemFilters.type((String)"jdk.CPULoad");
    public static final IItemFilter GC_G1MMU = ItemFilters.type((String)"jdk.G1MMU");
    public static final IItemFilter GC_CPU_TIME = ItemFilters.type((String)"jdk.GCCPUTime");
    public static final IItemFilter GC_PAUSE = ItemFilters.type((String)"jdk.GCPhasePause");
    public static final IItemFilter GC_PAUSE_PHASE = ItemFilters.type((String[])new String[]{"jdk.GCPhasePauseLevel1", "jdk.GCPhasePauseLevel2", "jdk.GCPhasePauseLevel3", "jdk.GCPhasePauseLevel4"});
    public static final IItemFilter TIME_CONVERSION = ItemFilters.type((String)"jdk.CPUTimeStampCounter");
    public static final IItemFilter VM_INFO = ItemFilters.type((String)"jdk.JVMInformation");
    public static final IItemFilter THREAD_DUMP = ItemFilters.type((String)"jdk.ThreadDump");
    public static final IItemFilter SYSTEM_PROPERTIES = ItemFilters.type((String)"jdk.InitialSystemProperty");
    public static final IItemFilter JFR_DATA_LOST = ItemFilters.type((String)"jdk.DataLoss");
    public static final IItemFilter PROCESSES = ItemFilters.type((String)"jdk.SystemProcess");
    public static final IItemFilter OBJECT_COUNT = ItemFilters.type((String)"jdk.ObjectCount");
    public static final IItemFilter METASPACE_OOM = ItemFilters.type((String)"jdk.MetaspaceOOM");
    public static final IItemFilter COMPILATION = ItemFilters.type((String)"jdk.Compilation");
    public static final IItemFilter COMPILER_FAILURE = ItemFilters.type((String)"jdk.CompilationFailure");
    public static final IItemFilter COMPILER_STATS = ItemFilters.type((String)"jdk.CompilerStatistics");
    public static final IItemFilter OS_MEMORY_SUMMARY = ItemFilters.type((String)"jdk.PhysicalMemory");
    public static final IItemFilter HEAP_SUMMARY = ItemFilters.type((String)"jdk.GCHeapSummary");
    public static final IItemFilter HEAP_SUMMARY_BEFORE_GC = ItemFilters.and((IItemFilter[])new IItemFilter[]{HEAP_SUMMARY, BEFORE_GC});
    public static final IItemFilter HEAP_SUMMARY_AFTER_GC = ItemFilters.and((IItemFilter[])new IItemFilter[]{HEAP_SUMMARY, AFTER_GC});
    public static final IItemFilter METASPACE_SUMMARY = ItemFilters.type((String)"jdk.MetaspaceSummary");
    public static final IItemFilter METASPACE_SUMMARY_AFTER_GC = ItemFilters.and((IItemFilter[])new IItemFilter[]{METASPACE_SUMMARY, AFTER_GC});
    public static final IItemFilter RECORDINGS = ItemFilters.type((String)"jdk.ActiveRecording");
    public static final IItemFilter RECORDING_SETTING = ItemFilters.type((String)"jdk.ActiveSetting");
    public static final IItemFilter SAFE_POINTS = ItemFilters.type((String[])new String[]{"jdk.SafepointBegin", "jdk.SafepointCleanup", "jdk.SafepointCleanupTask", "jdk.SafepointStateSynchronization", "jdk.SafepointWaitBlocked", "jdk.SafepointEnd"});
    public static final IItemFilter VM_OPERATIONS = ItemFilters.type((String)"jdk.ExecuteVMOperation");
    public static final IItemFilter VM_OPERATIONS_BLOCKING_OR_SAFEPOINT = ItemFilters.and((IItemFilter[])new IItemFilter[]{ItemFilters.type((String)"jdk.ExecuteVMOperation"), ItemFilters.or((IItemFilter[])new IItemFilter[]{ItemFilters.equals(JdkAttributes.BLOCKING, (Object)true), ItemFilters.equals(JdkAttributes.SAFEPOINT, (Object)true)})});
    public static final IItemFilter VM_OPERATIONS_SAFEPOINT = ItemFilters.and((IItemFilter[])new IItemFilter[]{ItemFilters.type((String)"jdk.ExecuteVMOperation"), ItemFilters.equals(JdkAttributes.SAFEPOINT, (Object)true)});
    public static final IItemFilter APPLICATION_PAUSES = ItemFilters.or((IItemFilter[])new IItemFilter[]{GC_PAUSE, SAFE_POINTS, VM_OPERATIONS_SAFEPOINT});
    public static final IItemFilter BIASED_LOCKING_REVOCATIONS = ItemFilters.type((String[])new String[]{"jdk.BiasedLockClassRevocation", "jdk.BiasedLockRevocation", "jdk.BiasedLockSelfRevocation"});
    public static final IItemFilter THREAD_STATISTICS = ItemFilters.type((String)"jdk.JavaThreadStatistics");
    public static final IItemFilter THREAD_CPU_LOAD = ItemFilters.type((String)"jdk.ThreadCPULoad");
    public static final IItemFilter NATIVE_METHOD_SAMPLE = ItemFilters.type((String)"jdk.NativeMethodSample");
    public static final IItemFilter THREAD_START = ItemFilters.type((String)"jdk.ThreadStart");
    public static final IItemFilter THREAD_END = ItemFilters.type((String)"jdk.ThreadEnd");
    public static final IItemFilter AGENTS = ItemFilters.type((String[])new String[]{"jdk.JavaAgent", "jdk.NativeAgent"});
    public static final IItemFilter RSS = ItemFilters.type((String)"jdk.ResidentSetSize");

    public static class MethodFilter
    implements IItemFilter {
        private final String typeName;
        private final String methodName;

        public MethodFilter(String typeName, String methodName) {
            this.typeName = typeName;
            this.methodName = methodName;
        }

        public Predicate<IItem> getPredicate(IType<IItem> type) {
            final IMemberAccessor accessor = JfrAttributes.EVENT_STACKTRACE.getAccessor(type);
            if (accessor == null) {
                return PredicateToolkit.falsePredicate();
            }
            return new Predicate<IItem>(){

                @Override
                public boolean test(IItem o) {
                    IMCStackTrace st = (IMCStackTrace)accessor.getMember((Object)o);
                    if (st != null) {
                        for (IMCFrame frame : st.getFrames()) {
                            IMCMethod method = frame.getMethod();
                            if (!typeName.equals(method.getType().getFullName()) || !methodName.equals(method.getMethodName())) continue;
                            return true;
                        }
                    }
                    return false;
                }
            };
        }
    }
}

