/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rcp.application.actions;

import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.openjdk.jmc.rcp.application.ApplicationPlugin;
import org.openjdk.jmc.rcp.application.actions.Messages;
import org.openjdk.jmc.ui.MCPathEditorInput;
import org.openjdk.jmc.ui.WorkbenchToolkit;

public class OpenFileAction
extends Action {
    private static final String KLEENE_STAR_DOT = "*.";
    private static final String FILE_OPEN_FILTER_PATH = "file.open.filter.path";
    private static final String DEMO_DIRECTORY = "flightrecordings";
    private final IWorkbenchWindow window;

    public OpenFileAction(IWorkbenchWindow window) {
        super(Messages.OpenFileAction_OPEN_FILE_TITLE_TEXT);
        this.window = window;
        this.setEnabled(true);
    }

    private static String getDefaultFilterPath() {
        String result = OpenFileAction.getLastFilterPath();
        if (result == null && (result = OpenFileAction.getSamplePath()) == null && (result = OpenFileAction.getUserHomePath()) == null) {
            result = "./";
        }
        return result;
    }

    private static String getLastFilterPath() {
        return OpenFileAction.getIfExists(ApplicationPlugin.getDefault().getDialogSettings().get(FILE_OPEN_FILTER_PATH));
    }

    private static String getUserHomePath() {
        return OpenFileAction.getIfExists(System.getProperty("user.home"));
    }

    public static String getSamplePath() {
        String result = null;
        result = OpenFileAction.getJoinedIfExists(".", DEMO_DIRECTORY);
        if (result == null) {
            result = OpenFileAction.getJoinedIfExists(OpenFileAction.getEclipseLaunchedSamplesFolder(), DEMO_DIRECTORY);
        }
        return result;
    }

    private static String getEclipseLaunchedSamplesFolder() {
        String app = Platform.getBundle((String)"org.openjdk.jmc.rcp.application").getLocation();
        app = app.substring("reference:file:/".length());
        File base = new File(app).getParentFile();
        return OpenFileAction.getJoinedIfExists(base.getAbsolutePath(), "org.openjdk.jmc.rcp.product/rootfiles/");
    }

    private static String getIfExists(String path) {
        if (OpenFileAction.exists(path)) {
            return path;
        }
        return null;
    }

    private static boolean exists(String path) {
        if (path != null) {
            return new File(path).exists();
        }
        return false;
    }

    private static String getJoinedIfExists(String base, String child) {
        if (base != null && child != null) {
            return OpenFileAction.getIfExists(new File(base, child).getPath());
        }
        return null;
    }

    private static void setDefaultFilterPath(String path) {
        IDialogSettings settings = ApplicationPlugin.getDefault().getDialogSettings();
        settings.put(FILE_OPEN_FILTER_PATH, path);
    }

    public void run() {
        OpenFileAction.openFile(this.window);
    }

    public static void openFile(IWorkbenchWindow inWindow) {
        FileDialog dialog = new FileDialog(inWindow.getShell(), 4098);
        dialog.setFilterPath(OpenFileAction.getDefaultFilterPath());
        OpenFileAction.setFilterNamesAndExtensions(dialog);
        dialog.setText(Messages.OpenFileAction_OPEN_FILE_TITLE);
        if (dialog.open() == null) {
            return;
        }
        String[] names = dialog.getFileNames();
        if (names != null) {
            String filterPath = dialog.getFilterPath();
            OpenFileAction.setDefaultFilterPath(filterPath);
            int numberOfFilesNotFound = 0;
            StringBuffer notFound = new StringBuffer();
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                File file = new File(filterPath + File.separator + name);
                if (file.exists()) {
                    WorkbenchToolkit.openEditor((IWorkbenchWindow)inWindow, (IPathEditorInput)new MCPathEditorInput(file, true));
                } else {
                    if (++numberOfFilesNotFound > 1) {
                        notFound.append('\n');
                    }
                    notFound.append(file.getName());
                }
                ++n2;
            }
            if (numberOfFilesNotFound > 0) {
                String msgFmt = numberOfFilesNotFound == 1 ? Messages.OpenFileAction_CANT_FIND_SINGLE_FILE_TEXT : Messages.OpenFileAction_CANT_FIND_MULTIPLE_FILES_TEXT;
                String msg = NLS.bind((String)msgFmt, (Object[])new Object[]{notFound.toString()});
                MessageDialog.openError((Shell)inWindow.getShell(), (String)Messages.OpenFileAction_ERROR_WHEN_OPENING_FILE_TEXT_TITLE, (String)msg);
            }
        }
    }

    private static void setFilterNamesAndExtensions(FileDialog dialog) {
        IFileEditorMapping[] fileExtensions = PlatformUI.getWorkbench().getEditorRegistry().getFileEditorMappings();
        String[] filterExtensions = new String[fileExtensions.length + 1];
        int i = 0;
        while (i < fileExtensions.length) {
            filterExtensions[i] = KLEENE_STAR_DOT + fileExtensions[i].getExtension();
            ++i;
        }
        filterExtensions[fileExtensions.length] = "*";
        dialog.setFilterExtensions(filterExtensions);
        dialog.setFilterIndex(fileExtensions.length);
    }
}

