/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.greychart.impl;

public final class LongWorldToDeviceConverter {
    private final int m_deviceMinimum;
    private final int m_deviceWidth;
    private final long m_worldMinimum;
    private final long m_worldWidth;

    public LongWorldToDeviceConverter(int deviceMinimum, int deviceMaximum, long worldMinimum, long worldMaximum) {
        this.m_deviceMinimum = deviceMinimum;
        this.m_worldMinimum = worldMinimum;
        this.m_worldWidth = worldMaximum - worldMinimum;
        this.m_deviceWidth = deviceMaximum - deviceMinimum;
    }

    public int getDeviceCoordinate(double worldCoordinate) {
        double normalizedCoordinate = (worldCoordinate - (double)this.m_worldMinimum) / (double)this.m_worldWidth;
        return (int)((double)this.m_deviceMinimum + normalizedCoordinate * (double)this.m_deviceWidth + 0.5);
    }

    public double getWorldCoordinate(int deviceCoordinate) {
        double normalizedCoordinate = (double)(deviceCoordinate - this.m_deviceMinimum) / (double)this.m_deviceWidth;
        return (double)this.m_worldMinimum + normalizedCoordinate * (double)this.m_worldWidth;
    }

    public int getDeviceWidth() {
        return this.m_deviceWidth;
    }

    public boolean canCalculateWorldCoordinate() {
        return this.m_deviceWidth != 0;
    }

    public boolean canCalculateDeviceCoordinate() {
        return (double)this.m_worldWidth != 0.0;
    }
}

