/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.editor;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.openjdk.jmc.console.agent.messages.internal.Messages;
import org.openjdk.jmc.ui.UIPlugin;

public class AgentEditorAction
extends Action {
    private final AgentEditorActionType actionType;
    private Runnable runnable = () -> {};

    AgentEditorAction(AgentEditorActionType actionType) {
        super(actionType.message, actionType.action);
        this.actionType = actionType;
        this.setToolTipText(actionType.message);
        this.setImageDescriptor(actionType.imageDescriptor);
    }

    public void run() {
        this.runnable.run();
    }

    public void setRunnable(Runnable callback) {
        this.runnable = callback;
    }

    public AgentEditorActionType getType() {
        return this.actionType;
    }

    static enum AgentEditorActionType {
        REFRESH(Messages.AgentEditorAction_MESSAGE_REFRESH, 1, UIPlugin.getDefault().getMCImageDescriptor("refresh_tab.gif")),
        LOAD_PRESET(Messages.AgentEditorAction_MESSAGE_LOAD_PRESET, 1, UIPlugin.getDefault().getMCImageDescriptor("change.gif")),
        SAVE_AS_PRESET(Messages.AgentEditorAction_MESSAGE_SAVE_AS_PRESET, 1, UIPlugin.getDefault().getMCImageDescriptor("save_edit.gif"));

        private final String message;
        private final int action;
        private final ImageDescriptor imageDescriptor;

        private AgentEditorActionType(String message, int action, ImageDescriptor imageDescriptor) {
            this.message = message;
            this.action = action;
            this.imageDescriptor = imageDescriptor;
        }
    }
}

