/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.manager.model;

import org.openjdk.jmc.console.agent.manager.model.CapturedValue;
import org.openjdk.jmc.console.agent.manager.model.Event;
import org.openjdk.jmc.console.agent.manager.model.IMethodParameter;
import org.openjdk.jmc.console.agent.messages.internal.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MethodParameter
extends CapturedValue
implements IMethodParameter {
    private static final String DEFAULT_PARAMETER_NAME = "New Parameter";
    private static final int DEFAULT_INDEX = 0;
    private static final String XML_TAG_PARAMETER = "parameter";
    private static final String XML_ATTRIBUTE_INDEX = "index";
    private final Event event;
    private int index;

    MethodParameter(Event event) {
        this.event = event;
        this.index = 0;
        this.setName(DEFAULT_PARAMETER_NAME);
    }

    MethodParameter(Event event, Element element) {
        super(element);
        this.event = event;
        this.index = Integer.parseInt(element.getAttribute(XML_ATTRIBUTE_INDEX));
    }

    @Override
    public Element buildElement(Document document) {
        Element element = super.buildElement(document);
        element = (Element)document.renameNode(element, null, XML_TAG_PARAMETER);
        element.setAttribute(XML_ATTRIBUTE_INDEX, String.valueOf(this.index));
        return element;
    }

    @Override
    public void setName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException(Messages.MethodParameter_ERROR_NAME_CANNOT_BE_EMPTY_OR_NULL);
        }
        super.setName(name);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException(Messages.MethodParameter_ERROR_INDEX_CANNOT_BE_LESS_THAN_ZERO);
        }
        this.index = index;
    }

    @Override
    public MethodParameter createWorkingCopy() {
        MethodParameter parameter = new MethodParameter(this.event);
        this.copyContentToWorkingCopy(parameter);
        parameter.index = this.index;
        return parameter;
    }
}

