/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.actionprovider.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.openjdk.jmc.common.action.IActionProvider;
import org.openjdk.jmc.rjmx.IServerHandle;
import org.openjdk.jmc.rjmx.RJMXPlugin;
import org.openjdk.jmc.rjmx.actionprovider.IActionProviderFactory;
import org.openjdk.jmc.rjmx.actionprovider.internal.ActionDescriptor;
import org.openjdk.jmc.rjmx.actionprovider.internal.ActionProvider;
import org.openjdk.jmc.rjmx.actionprovider.internal.ActionProviderDescriptor;

public class ActionProviderRepository {
    public static IActionProvider buildActionProvider(IServerHandle handle) {
        ActionProvider ap = new ActionProvider();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        ArrayList<IConfigurationElement> addOnElements = new ArrayList<IConfigurationElement>();
        HashMap<String, ActionProviderDescriptor> declaredProviders = new HashMap<String, ActionProviderDescriptor>();
        List<IConfigurationElement> configurationElements = Arrays.asList(registry.getConfigurationElementsFor("org.openjdk.jmc.rjmx.actionProvider"));
        Comparator<IConfigurationElement> comparator = new Comparator<IConfigurationElement>(){

            public int getPrio(IConfigurationElement e) {
                String prio = e.getAttribute("priority");
                return prio == null ? 0 : Integer.parseInt(prio);
            }

            @Override
            public int compare(IConfigurationElement o1, IConfigurationElement o2) {
                return this.getPrio(o1) - this.getPrio(o2);
            }
        };
        configurationElements.sort(comparator);
        for (IConfigurationElement element : configurationElements) {
            try {
                ActionProviderRepository.loadElement(element, handle, ap, declaredProviders);
                if (!element.getName().equals("addon")) continue;
                addOnElements.add(element);
            }
            catch (Exception e) {
                RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not load extension for org.openjdk.jmc.rjmx.actionProvider", e);
            }
        }
        addOnElements.sort(comparator);
        for (IConfigurationElement element : addOnElements) {
            String id = element.getAttribute("location");
            ActionProviderDescriptor apd = (ActionProviderDescriptor)declaredProviders.get(id);
            if (apd == null) continue;
            try {
                IConfigurationElement[] iConfigurationElementArray = element.getChildren();
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement e = iConfigurationElementArray[n2];
                    ActionProviderRepository.loadElement(e, handle, apd, null);
                    ++n2;
                }
            }
            catch (Exception e) {
                RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not load extension for org.openjdk.jmc.rjmx.actionProvider", e);
            }
        }
        return ap;
    }

    private static IActionProvider buildProvider(IConfigurationElement providerElement, IServerHandle handle, Map<String, ActionProviderDescriptor> declaredProviders) throws Exception {
        ActionProviderDescriptor adp = new ActionProviderDescriptor(providerElement);
        IConfigurationElement[] iConfigurationElementArray = providerElement.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            ActionProviderRepository.loadElement(e, handle, adp, declaredProviders);
            ++n2;
        }
        if (adp.getId() != null && declaredProviders != null) {
            declaredProviders.put(adp.getId(), adp);
        }
        return adp;
    }

    private static void loadElement(IConfigurationElement element, IServerHandle handle, ActionProvider into, Map<String, ActionProviderDescriptor> declaredProviders) throws Exception {
        if (element.getName().equals("action")) {
            into.getActions().add(new ActionDescriptor(element, handle));
        } else if (element.getName().equals("provider")) {
            into.getProviders().add(ActionProviderRepository.buildProvider(element, handle, declaredProviders));
        } else if (element.getName().equals("providerFactory")) {
            IActionProviderFactory factory = (IActionProviderFactory)element.createExecutableExtension("class");
            factory.initialize(handle);
            into.getProviders().addAll(factory.getActionProviders());
            into.getActions().addAll(factory.getActions());
        }
    }
}

