/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.greychart.impl;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import org.openjdk.jmc.greychart.TickFormatter;
import org.openjdk.jmc.greychart.util.ChartRenderingToolkit;

public class DoubleFormatter
implements TickFormatter {
    private double lastLabelDistance = Double.MIN_VALUE;
    private double lastMin = Double.MAX_VALUE;
    private double lastMax = Double.MIN_VALUE;
    private NumberFormat formatter = DecimalFormat.getInstance();

    @Override
    public String format(Number value, Number min, Number max, Number labelDistance) {
        if (this.lastMin != min.doubleValue() || this.lastMax != max.doubleValue() || this.lastLabelDistance != labelDistance.doubleValue()) {
            this.formatter = DoubleFormatter.createFormat(min.doubleValue(), max.doubleValue(), labelDistance.doubleValue());
            this.lastMin = min.doubleValue();
            this.lastMax = max.doubleValue();
            this.lastLabelDistance = labelDistance.doubleValue();
        }
        return this.formatter.format(value.doubleValue());
    }

    private static NumberFormat createFormat(double min, double max, double tickInterval) {
        NumberFormat format;
        double maxValue = Math.max(Math.abs(max), Math.abs(min));
        if (maxValue >= 1.0E9 || maxValue < 1.0E-9) {
            format = new EngineeringFormat(min, max, tickInterval);
        } else if (tickInterval == ChartRenderingToolkit.fastFloor(tickInterval)) {
            format = NumberFormat.getIntegerInstance();
        } else {
            int exp = DoubleFormatter.log10Exponent(tickInterval);
            format = NumberFormat.getInstance();
            format.setMaximumFractionDigits(-exp);
            format.setMinimumFractionDigits(-exp);
        }
        return format;
    }

    @Override
    public String getUnitString(Number min, Number max) {
        return "";
    }

    private static int log10Exponent(double d) {
        return (int)Math.round(ChartRenderingToolkit.fastFloor(ChartRenderingToolkit.log10(Math.abs(d))));
    }

    private static class EngineeringFormat
    extends NumberFormat {
        static final NumberFormat FORMAT = new DecimalFormat("##0.00");
        static final long serialVersionUID = 0L;
        private final double baseNumber;
        private final double lsnNumber;
        private final String exponent;

        public EngineeringFormat(double min, double max, double lsn) {
            this(min, max, lsn, new DecimalFormatSymbols());
        }

        public EngineeringFormat(double min, double max, double lsn, DecimalFormatSymbols symbols) {
            int minExp = DoubleFormatter.log10Exponent(min);
            int maxExp = DoubleFormatter.log10Exponent(max);
            int minBaseExp = this.getEvenThree(minExp);
            int maxBaseExp = this.getEvenThree(maxExp);
            int baseExp = Math.max(maxBaseExp, minBaseExp);
            StringBuffer sb = new StringBuffer("E");
            if (baseExp < 0) {
                sb.append(symbols.getMinusSign());
            }
            sb.append(Math.abs(baseExp));
            this.exponent = sb.toString();
            this.baseNumber = Math.pow(10.0, baseExp);
            int lsnExp = DoubleFormatter.log10Exponent(lsn);
            this.lsnNumber = Math.pow(10.0, lsnExp);
            FORMAT.setGroupingUsed(false);
        }

        private int getEvenThree(int minExp) {
            return minExp / 3 * 3;
        }

        @Override
        public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
            if ((double)Math.round(number / this.lsnNumber) == 0.0) {
                toAppendTo.append('0');
                return toAppendTo;
            }
            FORMAT.format(number / this.baseNumber, toAppendTo, pos);
            toAppendTo.append(this.exponent);
            return toAppendTo;
        }

        @Override
        public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
            return this.format((double)number, toAppendTo, pos);
        }

        @Override
        public Number parse(String source, ParsePosition parsePosition) {
            return null;
        }
    }
}

