/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.jolokia.preferences;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.openjdk.jmc.jolokia.JmcJolokiaPlugin;
import org.openjdk.jmc.jolokia.preferences.Messages;
import org.openjdk.jmc.jolokia.preferences.PreferenceConstants;

public class JolokiaPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
PreferenceConstants {
    private Map<Control, Object> dependantControls = new WeakHashMap<Control, Object>();

    public JolokiaPreferencePage() {
        super(1);
        this.setPreferenceStore(JmcJolokiaPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.JolokiaPreferencePage_Description);
    }

    public void createFieldEditors() {
        BooleanFieldEditor mainEnabler = new BooleanFieldEditor("discoverJolokia", Messages.JolokiaPreferencePage_Label, this.getFieldEditorParent()){

            protected void valueChanged(boolean oldValue, boolean newValue) {
                super.valueChanged(oldValue, newValue);
                JolokiaPreferencePage.this.enableDependantFields(newValue);
            }
        };
        this.addField((FieldEditor)mainEnabler);
        this.addTextField(new StringFieldEditor("multicastGroup", Messages.JolokiaPreferencePage_MulticastGroupLabel, this.getFieldEditorParent()), Messages.JolokiaPreferencePage_MulticastGroupTooltip);
        this.addTextField((StringFieldEditor)new IntegerFieldEditor("multicastPort", Messages.JolokiaPreferencePage_MulticastPortLabel, this.getFieldEditorParent()), Messages.JolokiaPreferencePage_MulticastPortTooltip);
        this.addDependantField((FieldEditor)new IntegerFieldEditor("discoverTimeout", Messages.JolokiaPreferencePage_DiscoverTimeoutLabel, this.getFieldEditorParent()), this.getControl());
    }

    public void init(IWorkbench workbench) {
    }

    private void addTextField(StringFieldEditor field, String tooltip) {
        Text textControl = field.getTextControl(this.getFieldEditorParent());
        this.addDependantField((FieldEditor)field, (Control)textControl);
        textControl.setToolTipText(tooltip);
        field.getLabelControl(this.getFieldEditorParent()).setToolTipText(tooltip);
    }

    private void addDependantField(FieldEditor field, Control control) {
        this.dependantControls.put(control, null);
        this.addField(field);
    }

    private void enableDependantFields(boolean enabled) {
        for (Control field : this.dependantControls.keySet()) {
            field.setEnabled(enabled);
        }
    }
}

