/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules;

import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openjdk.jmc.common.IDisplayable;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.util.FormatToolkit;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.TypedCollectionResult;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceFormatToolkit;
import org.owasp.encoder.Encode;

public class ResultToolkit {
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("(\\{.*?\\})");
    private static final FrameSeparator DEFAULT_SEPARATOR = new FrameSeparator(FrameSeparator.FrameCategorization.LINE, false);

    public static String populateMessage(IResult result, String string, boolean withHtml) {
        if (string == null) {
            return string;
        }
        String s = string;
        Matcher matcher = TEMPLATE_PATTERN.matcher(s);
        while (matcher.find()) {
            for (int i = 0; i < matcher.groupCount(); ++i) {
                String group = matcher.group(i);
                String subGroup = group.substring(1, group.length() - 1);
                TypedResult<?> typedResult = ResultToolkit.getResultById(result.getRule(), subGroup);
                if (typedResult != null) {
                    if (typedResult instanceof TypedCollectionResult) {
                        if (withHtml) {
                            StringBuilder collection = new StringBuilder();
                            collection.append("<ul>");
                            Collection results = result.getResult((TypedCollectionResult)typedResult);
                            for (Object o : results) {
                                collection.append("<li>");
                                if (o instanceof IDisplayable) {
                                    collection.append(Encode.forHtml((String)((IDisplayable)o).displayUsing("auto")));
                                } else if (o instanceof IMCFrame) {
                                    collection.append(Encode.forHtml((String)StacktraceFormatToolkit.formatFrame((IMCFrame)((IMCFrame)o), (FrameSeparator)DEFAULT_SEPARATOR)));
                                } else if (o instanceof IMCStackTrace) {
                                    collection.append(Encode.forHtml((String)FormatToolkit.getHumanReadable((IMCStackTrace)((IMCStackTrace)o))));
                                } else {
                                    collection.append(Encode.forHtml((String)typedResult.format(o)));
                                }
                                collection.append("</li>");
                            }
                            collection.append("</ul>");
                            s = s.replace(group, collection.toString());
                            continue;
                        }
                        Collection results = result.getResult((TypedCollectionResult)typedResult);
                        StringBuilder collection = new StringBuilder();
                        Iterator iter = results.iterator();
                        while (iter.hasNext()) {
                            Object typedResultInstance = iter.next();
                            if (typedResultInstance instanceof IDisplayable) {
                                collection.append(ResultToolkit.encodeIfNeeded(((IDisplayable)typedResultInstance).displayUsing("auto"), withHtml));
                            } else if (typedResultInstance instanceof IMCFrame) {
                                collection.append(ResultToolkit.encodeIfNeeded(StacktraceFormatToolkit.formatFrame((IMCFrame)((IMCFrame)typedResultInstance), (FrameSeparator)DEFAULT_SEPARATOR), withHtml));
                            } else if (typedResultInstance instanceof IMCStackTrace) {
                                collection.append(ResultToolkit.encodeIfNeeded(FormatToolkit.getHumanReadable((IMCStackTrace)((IMCStackTrace)typedResultInstance)), withHtml));
                            } else {
                                collection.append(ResultToolkit.encodeIfNeeded(typedResult.format(typedResultInstance), withHtml));
                            }
                            if (!iter.hasNext()) break;
                            collection.append(",");
                        }
                        s = s.replace(group, collection.toString());
                        continue;
                    }
                    Object typedResultInstance = result.getResult(typedResult);
                    if (typedResultInstance == null) continue;
                    if (typedResultInstance instanceof IDisplayable) {
                        s = s.replace(group, ResultToolkit.encodeIfNeeded(((IDisplayable)typedResultInstance).displayUsing("auto"), withHtml));
                        continue;
                    }
                    if (typedResultInstance instanceof IMCFrame) {
                        s = s.replace(group, ResultToolkit.encodeIfNeeded(StacktraceFormatToolkit.formatFrame((IMCFrame)((IMCFrame)typedResultInstance), (FrameSeparator)DEFAULT_SEPARATOR), withHtml));
                        continue;
                    }
                    if (typedResultInstance instanceof IMCStackTrace) {
                        s = s.replace(group, ResultToolkit.encodeIfNeeded(FormatToolkit.getHumanReadable((IMCStackTrace)((IMCStackTrace)typedResultInstance)), withHtml));
                        continue;
                    }
                    s = s.replace(group, ResultToolkit.encodeIfNeeded(typedResult.format(typedResultInstance), withHtml));
                    continue;
                }
                TypedPreference<?> typedPreference = ResultToolkit.getPreferenceById(result.getRule(), subGroup);
                if (typedPreference == null) continue;
                Object preference = result.getPreference(typedPreference);
                s = preference instanceof IDisplayable ? s.replace(group, ResultToolkit.encodeIfNeeded(((IDisplayable)preference).displayUsing("auto"), withHtml)) : s.replace(group, ResultToolkit.encodeIfNeeded(preference.toString(), withHtml));
            }
        }
        return s;
    }

    private static String encodeIfNeeded(String input, boolean shouldEncode) {
        if (shouldEncode) {
            return Encode.forHtml((String)input);
        }
        return input;
    }

    private static TypedResult<?> getResultById(IRule rule, String identifier) {
        Collection<TypedResult<?>> results = rule.getResults();
        if (results != null) {
            for (TypedResult<?> typedResult : results) {
                if (!typedResult.getIdentifier().equals(identifier)) continue;
                return typedResult;
            }
        }
        return null;
    }

    private static TypedPreference<?> getPreferenceById(IRule rule, String identifier) {
        Collection<TypedPreference<?>> preferences = rule.getConfigurationAttributes();
        if (preferences != null) {
            for (TypedPreference<?> typedPreference : preferences) {
                if (!typedPreference.getIdentifier().equals(identifier)) continue;
                return typedPreference;
            }
        }
        return null;
    }
}

