/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.heap.model;

import org.openjdk.jmc.joverflow.heap.model.JavaHeapObject;
import org.openjdk.jmc.joverflow.heap.model.Snapshot;
import org.openjdk.jmc.joverflow.heap.model.StackTrace;

public class Root
implements Comparable<Root> {
    private long id;
    private long refererId;
    private int type;
    private JavaHeapObject referer = null;
    private StackTrace stackTrace = null;
    public static final int INVALID_TYPE = 0;
    public static final int UNKNOWN = 1;
    public static final int SYSTEM_CLASS = 2;
    public static final int JNI_LOCAL = 3;
    public static final int JNI_GLOBAL = 4;
    public static final int THREAD_BLOCK = 5;
    public static final int BUSY_MONITOR = 6;
    public static final int JAVA_LOCAL = 7;
    public static final int NATIVE_STACK = 8;
    public static final int JAVA_STATIC = 9;
    private static final String UNKNOWN_ROOT_STR = "Unknown GC root";
    public static final Root UNKNOWN_ROOT = new Root(0L, 0L, 1, ""){

        @Override
        public String getIdString() {
            return Root.UNKNOWN_ROOT_STR;
        }
    };

    public Root(long id, long refererId, int type, String description) {
        this(id, refererId, type, description, null);
    }

    public Root(long id, long refererId, int type, String description, StackTrace stackTrace) {
        this.id = id;
        this.refererId = refererId;
        this.type = type;
        this.stackTrace = stackTrace;
    }

    public long getId() {
        return this.id;
    }

    public String getIdString() {
        return this.getTypeName() + "@" + this.getId();
    }

    public boolean isUnknownRoot() {
        return this == UNKNOWN_ROOT;
    }

    public String toString() {
        return this.getIdString();
    }

    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        switch (this.type) {
            case 0: {
                return "Invalid (?!?)";
            }
            case 1: {
                return "Unknown";
            }
            case 2: {
                return "System Class";
            }
            case 3: {
                return "JNI Local";
            }
            case 4: {
                return "JNI Global";
            }
            case 5: {
                return "Thread Block";
            }
            case 6: {
                return "Busy Monitor";
            }
            case 7: {
                return "Java Local";
            }
            case 8: {
                return "Native Stack (possibly Java local)";
            }
            case 9: {
                return "Java Static";
            }
        }
        return "??";
    }

    public JavaHeapObject getReferer() {
        return this.referer;
    }

    public StackTrace getStackTrace() {
        return this.stackTrace;
    }

    void resolve(Snapshot ss) {
        if (this.refererId != 0L) {
            this.referer = ss.getObjectForId(this.refererId);
        }
        if (this.stackTrace != null) {
            this.stackTrace.resolve(ss);
        }
    }

    @Override
    public int compareTo(Root other) {
        if (other.type != this.type) {
            return other.type - this.type;
        }
        return 0;
    }
}

