/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.preferences;

import java.util.logging.Level;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.openjdk.jmc.common.security.PersistentCredentials;
import org.openjdk.jmc.common.security.SecurityException;
import org.openjdk.jmc.common.security.SecurityManagerFactory;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.console.ui.ConsolePlugin;
import org.openjdk.jmc.console.ui.messages.internal.Messages;
import org.openjdk.jmc.ui.misc.IntFieldEditor;
import org.openjdk.jmc.ui.preferences.LongQuantityFieldEditor;

public class CommunicationPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String TEXT_FIELD_NAME_KEY = "name";
    public static final String UPDATE_INTERVAL_FIELD_NAME = "preference.communication.text.interval";
    public static final String RETAINED_EVENT_FIELD_NAME = "preference.communication.text.retained";
    public static final String SERVER_HOST_FIELD_NAME = "preference.communication.text.host";
    public static final String SERVER_PORT_FIELD_NAME = "preference.communication.text.port";
    public static final String USERNAME_FIELD_NAME = "preference.communication.text.username";
    public static final String PASSWORD_FIELD_NAME = "preference.communication.text.password";
    private IntFieldEditor mailServerPort;
    private Text userField;
    private Text passwordField;

    public CommunicationPage() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.openjdk.jmc.rjmx"));
        this.setDescription(Messages.CommunicationPage_DESCRIPTION);
    }

    public void createFieldEditors() {
        Composite updateIntervalParent = this.getFieldEditorParent();
        LongQuantityFieldEditor updateInterval = new LongQuantityFieldEditor("org.openjdk.jmc.console.preferences.updateinterval", Messages.CommunicationPage_CAPTION_DEFAULT_UPDATE_INTERVAL, updateIntervalParent, (IUnit)UnitLookup.MILLISECOND);
        updateInterval.setValidRange((IQuantity)UnitLookup.MILLISECOND.quantity(1L), (IQuantity)UnitLookup.MILLISECOND.quantity(Integer.MAX_VALUE));
        updateInterval.getTextControl(updateIntervalParent).setData(TEXT_FIELD_NAME_KEY, (Object)UPDATE_INTERVAL_FIELD_NAME);
        this.addField((FieldEditor)updateInterval);
        Composite retainedEventParent = this.getFieldEditorParent();
        IntegerFieldEditor retainedEventValues = new IntegerFieldEditor("rjmx.events.retained", Messages.CommunicationPage_CAPTION_RETAINED_EVENT_VALUES, retainedEventParent);
        retainedEventValues.setValidRange(1, Integer.MAX_VALUE);
        retainedEventValues.getTextControl(retainedEventParent).setData(TEXT_FIELD_NAME_KEY, (Object)RETAINED_EVENT_FIELD_NAME);
        this.addField((FieldEditor)retainedEventValues);
        Composite mailServerParent = this.getFieldEditorParent();
        StringFieldEditor mailServer = new StringFieldEditor("rjmx.smtp.server", Messages.CommunicationPage_CAPTION_MAIL_SERVER, mailServerParent);
        mailServer.getTextControl(mailServerParent).setData(TEXT_FIELD_NAME_KEY, (Object)SERVER_HOST_FIELD_NAME);
        this.addField((FieldEditor)mailServer);
        Composite mailServerPortParent = this.getFieldEditorParent();
        this.mailServerPort = new IntFieldEditor("rjmx.smtp.server.port", Messages.CommunicationPage_CAPTION_MAIL_SERVER_PORT, mailServerPortParent);
        this.mailServerPort.getTextControl(mailServerPortParent).setData(TEXT_FIELD_NAME_KEY, (Object)SERVER_PORT_FIELD_NAME);
        this.addField((FieldEditor)this.mailServerPort);
        BooleanFieldEditor mailServerSecure = new BooleanFieldEditor("rjmx.smtp.server.secure", Messages.CommunicationPage_CAPTION_SECURE_MAIL_SERVER, this.getFieldEditorParent());
        this.addField((FieldEditor)mailServerSecure);
        BooleanFieldEditor mailServerStarttls = new BooleanFieldEditor("rjmx.smtp.server.starttls.encryption", Messages.CommunicationPage_CAPTION_SECURE_MAIL_SERVER_STARTTLS, this.getFieldEditorParent());
        this.addField((FieldEditor)mailServerStarttls);
        this.createCredentialFields();
        this.loadCredentials();
    }

    private void createCredentialFields() {
        Label userLabel = new Label(this.getFieldEditorParent(), 0);
        userLabel.setText(Messages.CommunicationPage_CAPTION_MAIL_SERVER_USER);
        this.userField = new Text(this.getFieldEditorParent(), 2052);
        this.userField.setLayoutData((Object)new GridData(768));
        this.userField.setData(TEXT_FIELD_NAME_KEY, (Object)USERNAME_FIELD_NAME);
        Label passLabel = new Label(this.getFieldEditorParent(), 0);
        passLabel.setText(Messages.CommunicationPage_CAPTION_MAIL_SERVER_PASSWORD);
        this.passwordField = new Text(this.getFieldEditorParent(), 0x400804);
        this.passwordField.setLayoutData((Object)new GridData(768));
        this.passwordField.setData(TEXT_FIELD_NAME_KEY, (Object)PASSWORD_FIELD_NAME);
    }

    private void loadCredentials() {
        String key = this.getPreferenceStore().getString("rjmx.smtp.server.credentials");
        if (key != null && !"".equals(key)) {
            try {
                PersistentCredentials credentials = new PersistentCredentials(key);
                this.userField.setText(credentials.getUsername());
                this.passwordField.setText(credentials.getPassword());
                return;
            }
            catch (SecurityException e) {
                ConsolePlugin.getDefault().getLogger().log(Level.WARNING, "Could not load stored SMTP credentials!", e);
            }
        }
        this.userField.setText("");
        this.passwordField.setText("");
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        super.performOk();
        this.storeCredentials();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.userField.setText("");
        this.passwordField.setText("");
    }

    private void storeCredentials() {
        String oldCredentialsKey = this.getPreferenceStore().getString("rjmx.smtp.server.credentials");
        if (this.userField.getText().equals("") && this.passwordField.getText().equals("")) {
            this.getPreferenceStore().setValue("rjmx.smtp.server.credentials", "");
            this.pruneOldCredentials(oldCredentialsKey);
            return;
        }
        try {
            PersistentCredentials credentials = new PersistentCredentials(this.userField.getText(), this.passwordField.getText());
            this.getPreferenceStore().setValue("rjmx.smtp.server.credentials", credentials.getExportedId());
            this.pruneOldCredentials(oldCredentialsKey);
        }
        catch (SecurityException e) {
            ConsolePlugin.getDefault().getLogger().log(Level.WARNING, "Could not store SMTP credentials!", e);
        }
    }

    private void pruneOldCredentials(String oldCredentialsKey) {
        this.pruneSecurityManager(oldCredentialsKey, "", "mail server credentials");
    }

    private void pruneSecurityManager(String oldKey, String defaultKey, String description) {
        if (oldKey != null && !oldKey.equals(defaultKey)) {
            try {
                SecurityManagerFactory.getSecurityManager().withdraw(oldKey);
            }
            catch (SecurityException e) {
                ConsolePlugin.getDefault().getLogger().log(Level.WARNING, "Could not remove old " + description + "!", e);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        FieldEditor editor;
        Object src;
        if (event.getProperty().equals("field_editor_value") && (src = event.getSource()) instanceof FieldEditor && "rjmx.smtp.server.secure".equals((editor = (FieldEditor)src).getPreferenceName())) {
            boolean secure = ((BooleanFieldEditor)editor).getBooleanValue();
            int port = this.mailServerPort.getIntValue();
            if (secure && port == 25) {
                this.mailServerPort.setStringValue(String.valueOf(465));
            } else if (port == 465) {
                this.mailServerPort.setStringValue(String.valueOf(25));
            }
            return;
        }
        super.propertyChange(event);
    }
}

