/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.celleditors;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.openjdk.jmc.ui.celleditors.ClearableTextCellEditor;

public class CharacterEditor
extends ClearableTextCellEditor {
    private static final String PREFIX = "\\u";
    private Character c;
    private boolean allowNull;

    public CharacterEditor(Composite parent, boolean allowNull) {
        super(parent);
        this.allowNull = allowNull;
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                StringBuilder sb = new StringBuilder(CharacterEditor.this.text.getText());
                if (e.character == '\b' || e.character == '\u007f') {
                    sb.delete(e.start, e.end);
                } else {
                    sb.replace(e.start, e.end, e.text);
                }
                e.doit = sb.length() < 2 || this.isUnicodeChar(sb.toString());
            }

            boolean isUnicodeChar(String str) {
                if (str.equals(CharacterEditor.PREFIX)) {
                    return true;
                }
                if (str.length() > 6 || !str.startsWith(CharacterEditor.PREFIX)) {
                    return false;
                }
                char[] cArray = str.substring(CharacterEditor.PREFIX.length()).toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    if (Character.digit(c, 16) < 0) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        });
    }

    @Override
    public boolean allowClear() {
        return this.allowNull;
    }

    protected void editOccured(ModifyEvent e) {
        try {
            this.c = this.parseChar(this.text.getText().trim());
            this.setValueValid(true);
        }
        catch (Exception exception) {
            this.setValueValid(false);
        }
    }

    private Character parseChar(String str) {
        if (this.allowNull && "".equals(str)) {
            return null;
        }
        if (str.length() == 1) {
            return Character.valueOf(str.charAt(0));
        }
        return Character.valueOf((char)Integer.parseInt(str.substring(PREFIX.length()), 16));
    }

    private static String formatChar(Character c) {
        char charValue = c.charValue();
        if (charValue >= ' ' && charValue < '\u0100') {
            return c.toString();
        }
        return PREFIX + String.format("%04X", charValue);
    }

    protected void doSetValue(Object value) {
        this.c = (Character)value;
        super.doSetValue((Object)(value == null ? "" : CharacterEditor.formatChar(this.c)));
    }

    protected Object doGetValue() {
        return this.c;
    }
}

