/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.Comparator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface Deployable {
    public static final Pattern EE_ENVIRONMENT_NAME_PATTERN = Pattern.compile("ee(\\d+)");
    public static final Comparator<String> ENVIRONMENT_COMPARATOR = (e1, e2) -> {
        Matcher m1 = EE_ENVIRONMENT_NAME_PATTERN.matcher((CharSequence)e1);
        Matcher m2 = EE_ENVIRONMENT_NAME_PATTERN.matcher((CharSequence)e2);
        if (m1.matches()) {
            if (m2.matches()) {
                int n1 = Integer.parseInt(m1.group(1));
                int n2 = Integer.parseInt(m2.group(1));
                return Integer.compare(n1, n2);
            }
            return 1;
        }
        if (m2.matches()) {
            return -1;
        }
        return e1.compareTo((String)e2);
    };
    public static final String ATTRIBUTE_PREFIX = "jetty.deploy.attribute.";
    public static final String TEMP_DIR = "jetty.deploy.tempDir";
    public static final String CONFIGURATION_CLASSES = "jetty.deploy.configurationClasses";
    public static final String CONTAINER_SCAN_JARS = "jetty.deploy.containerScanJarPattern";
    public static final String CONTEXT_PATH = "jetty.deploy.contextPath";
    public static final String CONTEXT_HANDLER_CLASS = "jetty.deploy.contextHandlerClass";
    public static final String DEFAULTS_DESCRIPTOR = "jetty.deploy.defaultsDescriptor";
    public static final String ENVIRONMENT = "environment";
    public static final String ENVIRONMENT_XML = "jetty.deploy.environmentXml";
    public static final String EXTRACT_WARS = "jetty.deploy.extractWars";
    public static final String PARENT_LOADER_PRIORITY = "jetty.deploy.parentLoaderPriority";
    public static final String SCI_EXCLUSION_PATTERN = "jetty.deploy.servletContainerInitializerExclusionPattern";
    public static final String SCI_ORDER = "jetty.deploy.servletContainerInitializerOrder";
    public static final String WAR = "jetty.deploy.war";
    public static final String WEBINF_SCAN_JARS = "jetty.deploy.webInfScanJarPattern";

    public void initializeDefaults(Map<String, String> var1);
}

