/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards;

import java.util.function.Consumer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.openjdk.jmc.flightrecorder.configuration.model.xml.XMLModel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.gui.ErrorTracker;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.gui.GUIModel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.gui.ProducerEnvironment;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.gui.WidgetNode;

public final class RecordingTemplateControlView {
    private final Composite m_container;
    private ErrorTracker m_errorTracker;

    public RecordingTemplateControlView(Composite parent, Consumer<String> errorConsumer) {
        this.m_container = parent;
        this.m_errorTracker = new ErrorTracker(errorConsumer);
    }

    public void cleanCreate(XMLModel xmlModel) {
        this.cleanControls();
        this.createProducerControls(xmlModel, this.m_container);
        this.m_container.layout();
    }

    public void create(XMLModel xmlModel) {
        this.createProducerControls(xmlModel, this.m_container);
    }

    private void cleanControls() {
        Control[] controlArray = this.m_container.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
    }

    private void createProducerControls(XMLModel xmlModel, Composite parent) {
        GUIModel uiModel = new GUIModel(xmlModel);
        uiModel.evaluate();
        for (ProducerEnvironment producer : uiModel.getProducers()) {
            if (producer.getWidgets().isEmpty()) continue;
            this.createProducer(parent, producer);
        }
    }

    private void createProducer(Composite parent, ProducerEnvironment producer) {
        Group g = this.getProducerGroup(parent, producer);
        GridLayout layout = new GridLayout(3, false);
        layout.verticalSpacing = 7;
        g.setLayout((Layout)layout);
        this.addProducerDescription(producer, g);
        for (WidgetNode widget : producer.getWidgets()) {
            widget.create((Composite)g, layout.numColumns, (arg_0, arg_1) -> ((ErrorTracker)this.m_errorTracker).trackError(arg_0, arg_1));
        }
    }

    private void addProducerDescription(ProducerEnvironment producer, Group g) {
        String prodDesc = producer.getDescription();
        if (prodDesc != null && prodDesc.length() > 0) {
            Label prodDescLabel = new Label((Composite)g, 0);
            prodDescLabel.setText(producer.getDescription());
            GridData gd = new GridData(16384, 0x1000000, true, false, 3, 1);
            prodDescLabel.setLayoutData((Object)gd);
        }
    }

    private Group getProducerGroup(Composite parent, ProducerEnvironment producer) {
        String producerText = this.getDescriptionName(producer);
        Group g = new Group(parent, 0);
        g.setText(producerText);
        g.setLayoutData((Object)new GridData(4, 4, true, true));
        return g;
    }

    private String getDescriptionName(ProducerEnvironment producer) {
        if (producer.getName().length() > 0) {
            return producer.getName();
        }
        return producer.getURI();
    }
}

