/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.recordingconfiguration;

import java.util.List;
import org.openjdk.jmc.common.unit.IConstraint;
import org.openjdk.jmc.flightrecorder.configuration.events.EventOptionID;
import org.openjdk.jmc.flightrecorder.configuration.events.IEventTypeID;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.model.EventConfigurationModel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.model.EventOptionVisitor;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.recordingconfiguration.PathElement;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.recordingconfiguration.PropertyContainer;

public final class PropertyContentBuilder
implements EventOptionVisitor {
    private final EventConfigurationModel model;
    private PropertyContainer.FolderNode dummyRootFolder;

    public PropertyContentBuilder(EventConfigurationModel model) {
        this.model = model;
    }

    public static List<? extends PathElement> build(EventConfigurationModel model) {
        return new PropertyContentBuilder(model).build();
    }

    private List<? extends PathElement> build() {
        this.dummyRootFolder = new PropertyContainer.FolderNode(null, null, PathElement.PathElementKind.IN_BOTH);
        this.model.accept(this);
        return this.dummyRootFolder.getChildren();
    }

    @Override
    public void visitEventType(PathElement.PathElementKind kind, IEventTypeID eventTypeID, String[] category, String label, String description) {
        this.findOrCreateEventNode(this.dummyRootFolder, eventTypeID, kind, category, label, description);
    }

    @Override
    public void visitOption(String value, IConstraint<?> constraint, PathElement.PathElementKind kind, EventOptionID eventOptionID, String[] category, String optionLabel, String optionDescription, String eventLabel, String eventDescription) {
        PropertyContainer.EventNode eventNode = this.findOrCreateEventNode(this.dummyRootFolder, eventOptionID.getEventTypeID(), kind, category, eventLabel, eventDescription);
        eventNode.addToOption(eventOptionID, optionLabel, optionDescription, kind, value, constraint);
    }

    private PropertyContainer.EventNode findOrCreateEventNode(PropertyContainer.FolderNode folder, IEventTypeID eventTypeID, PathElement.PathElementKind kind, String[] category, String label, String description) {
        int i = 0;
        while (i < category.length) {
            folder = folder.createOrGetFolder(category[i], kind);
            ++i;
        }
        return folder.createOrGetEvent(eventTypeID, kind, label, description);
    }
}

