/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rcp.application.scripting;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.openjdk.jmc.rcp.application.ApplicationPlugin;
import org.openjdk.jmc.rcp.application.scripting.model.Line;
import org.openjdk.jmc.rcp.application.scripting.model.OperatingSystem;
import org.openjdk.jmc.rcp.application.scripting.model.Process;
import org.openjdk.jmc.rcp.application.scripting.model.Program;
import org.openjdk.jmc.ui.misc.DisplayToolkit;

final class MarkerPainter
implements PaintListener,
Observer {
    static final int MARKER_WIDTH = 15;
    private final OperatingSystem m_os;
    private final StyledText m_control;
    private final Canvas m_markerArea;
    private final Image m_markerImage;
    private final Image m_instructionPointerImage;

    MarkerPainter(Canvas markerArea, OperatingSystem os, StyledText control) {
        this.m_os = os;
        this.m_control = control;
        this.m_markerArea = markerArea;
        this.m_markerArea.addPaintListener((PaintListener)this);
        this.m_markerImage = ApplicationPlugin.getDefault().getImageRegistry().getDescriptor("/icons/error_marker.gif").createImage();
        this.m_instructionPointerImage = ApplicationPlugin.getDefault().getImageRegistry().getDescriptor("/icons/inst_ptr_top.gif").createImage();
        this.hookMarkersListeners();
        this.hookImageDisposeListener(this.m_markerImage, this.m_instructionPointerImage);
    }

    private void hookImageDisposeListener(final Image ... images) {
        this.m_markerArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Image[] imageArray = images;
                int n = images.length;
                int n2 = 0;
                while (n2 < n) {
                    Image image = imageArray[n2];
                    image.dispose();
                    ++n2;
                }
            }
        });
    }

    private void hookMarkersListeners() {
        this.m_os.getProcessInFocus().getProgram().addObserver(this);
        this.m_os.getProcessInFocus().addObserver(this);
        this.m_control.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MarkerPainter.this.update();
            }
        });
        this.m_control.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MarkerPainter.this.update(null, null);
            }
        });
        this.m_control.addCaretListener(new CaretListener(){

            public void caretMoved(CaretEvent event) {
                DisplayToolkit.safeAsyncExec((Display)event.display, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MarkerPainter.this.update();
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintControl(PaintEvent e) {
        Program program;
        Program program2 = program = this.m_os.getProcessInFocus().getProgram();
        synchronized (program2) {
            this.drawProgramCounter(e.gc, this.m_os.getProcessInFocus());
            this.drawMarkers(e.gc, this.m_os.getProcessInFocus());
        }
    }

    private int drawMarkers(GC gc, Process p) {
        int lineNumber = 0;
        for (Line line : p.getProgram().getSourceCode()) {
            if (line.getErrorMessage() != null) {
                this.draw(gc, lineNumber, this.m_markerImage);
            }
            ++lineNumber;
        }
        return lineNumber;
    }

    private void drawProgramCounter(GC gc, Process p) {
        if (this.m_os.getProcessInFocus().isRunning()) {
            this.draw(gc, p.getInstructionPointer(), this.m_instructionPointerImage);
        }
    }

    private void draw(GC gc, int line, Image image) {
        int startHeight = this.m_control.getLinePixel(line);
        if (startHeight >= 0) {
            gc.drawImage(image, 0, startHeight + 2);
        }
    }

    void update() {
        this.m_markerArea.redraw();
    }

    @Override
    public void update(Observable o, Object arg) {
        this.update();
    }
}

