/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.openjdk.jmc.joverflow.support.RefChainElement;
import org.openjdk.jmc.joverflow.ui.model.ClusterType;
import org.openjdk.jmc.joverflow.ui.model.ModelListener;
import org.openjdk.jmc.joverflow.ui.model.ObjectCluster;
import org.openjdk.jmc.joverflow.ui.model.ReferenceChain;
import org.openjdk.jmc.joverflow.ui.viewers.AncestorViewer;
import org.openjdk.jmc.joverflow.ui.viewers.ClusterGroupViewer;
import org.openjdk.jmc.joverflow.ui.viewers.OverheadTypeViewer;
import org.openjdk.jmc.joverflow.ui.viewers.ReferrerViewer;

public class JOverflowUi
extends Composite {
    private Collection<ReferenceChain> mModel;
    private final OverheadTypeViewer mOverheadTypeViewer;
    private final ClusterGroupViewer mClusterGroupViewer;
    private final ReferrerViewer mReferrerViewer;
    private final AncestorViewer mAncestorViewer;
    private final List<ModelListener> mModelListeners = new ArrayList<ModelListener>();

    public JOverflowUi(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        SashForm hSash = new SashForm((Composite)this, 0);
        SashForm vSashLeft = new SashForm((Composite)hSash, 512);
        Composite topLeftContainer = new Composite((Composite)vSashLeft, 0);
        topLeftContainer.setLayout((Layout)new FillLayout(256));
        this.mOverheadTypeViewer = new OverheadTypeViewer(topLeftContainer, 0);
        this.mOverheadTypeViewer.addFilterChangedListener(this::updateModel);
        Composite bottomLeftContainer = new Composite((Composite)vSashLeft, 0);
        bottomLeftContainer.setLayout((Layout)new FillLayout(256));
        this.mClusterGroupViewer = new ClusterGroupViewer(bottomLeftContainer, 0);
        this.mClusterGroupViewer.addFilterChangedListener(this::updateModel);
        vSashLeft.setWeights(new int[]{1, 1});
        SashForm vSashRight = new SashForm((Composite)hSash, 512);
        Composite topRightContainer = new Composite((Composite)vSashRight, 0);
        topRightContainer.setLayout((Layout)new FillLayout(256));
        this.mReferrerViewer = new ReferrerViewer(topRightContainer, 0);
        this.mReferrerViewer.addFilterChangedListener(this::updateModel);
        Composite bottomRightContainer = new Composite((Composite)vSashRight, 0);
        bottomRightContainer.setLayout((Layout)new FillLayout(256));
        this.mAncestorViewer = new AncestorViewer(bottomRightContainer, 0);
        this.mAncestorViewer.addFilterChangedListener(this::updateModel);
        vSashRight.setWeights(new int[]{1, 1});
        hSash.setWeights(new int[]{1, 1});
        this.mModelListeners.add(this.mClusterGroupViewer);
        this.mModelListeners.add(this.mReferrerViewer);
        this.mModelListeners.add(this.mAncestorViewer);
    }

    public void setModel(Collection<ReferenceChain> model) {
        this.mModel = model;
        long heapSize = 0L;
        for (ReferenceChain rc : model) {
            for (ObjectCluster oc : rc) {
                if (oc.getType() != ClusterType.ALL_OBJECTS) continue;
                heapSize += (long)oc.getMemory();
            }
        }
        this.mOverheadTypeViewer.setHeapSize(heapSize);
        this.mReferrerViewer.setHeapSize(heapSize);
        this.mClusterGroupViewer.setHeapSize(heapSize);
        this.mAncestorViewer.setHeapSize(heapSize);
        this.updateModel();
    }

    private void updateModel() {
        ClusterType currentType = this.mOverheadTypeViewer.getCurrentType();
        this.mClusterGroupViewer.setQualifierName(currentType == ClusterType.DUPLICATE_STRING || currentType == ClusterType.DUPLICATE_ARRAY ? "Duplicate" : null);
        for (ReferenceChain chain : this.mModel) {
            RefChainElement rce = chain.getReferenceChain();
            if (!this.mReferrerViewer.filter(rce) || !this.mAncestorViewer.filter(rce)) continue;
            for (ObjectCluster oc : chain) {
                if (!this.mClusterGroupViewer.filter(oc)) continue;
                this.mOverheadTypeViewer.include(oc, rce);
                if (!this.mOverheadTypeViewer.filter(oc)) continue;
                for (ModelListener l : this.mModelListeners) {
                    l.include(oc, chain.getReferenceChain());
                }
            }
        }
        this.mOverheadTypeViewer.allIncluded();
        for (ModelListener l : this.mModelListeners) {
            l.allIncluded();
        }
    }

    void reset() {
        this.mOverheadTypeViewer.reset();
        this.mReferrerViewer.reset();
        this.mClusterGroupViewer.reset();
        this.mAncestorViewer.reset();
        this.updateModel();
    }

    void addModelListener(ModelListener listener) {
        this.mModelListeners.add(listener);
        if (this.mModel != null) {
            this.updateModel();
        }
    }

    void removeModelListener(ModelListener listener) {
        this.mModelListeners.remove(listener);
    }
}

